/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class EBtresosStudioParser
extends RegexpLineParser {
    private static final String TRESOS_WARNING_PATTERN = "^(INFO|WARNING|ERROR)\\s\\d*-\\d*-\\d*,\\d*:\\d*:\\d*\\s\\(((\\p{Alnum}|_)*)\\)\\s(.*)$";
    private static final String[] TRESOS_INFO_MSGS_IGNORE = new String[]{"13014", "13030", "13015", "160001", "170001", "20053", "2113", "2501", "2506", "OS_1", "OS_3", "SWDUPDATER_10", "SWDUPDATER_14", "SWDUPDATER_24", "SWDUPDATER_7", "SWDUPDATER_8"};

    public EBtresosStudioParser() {
        super(Messages._Warnings_EBtresosStudio_ParserName(), Messages._Warnings_EBtresosStudio_LinkName(), Messages._Warnings_EBtresosStudio_TrendName(), TRESOS_WARNING_PATTERN);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        Priority priority;
        String fileName = "*.xdm";
        int lineNumber = 0;
        String type = matcher.group(1);
        String category = matcher.group(2);
        String message = matcher.group(4);
        if (type.equals("ERROR")) {
            Priority priority2 = Priority.HIGH;
        }
        if (type.equals("INFO")) {
            priority = Priority.NORMAL;
            for (String tresosMsgCategory : TRESOS_INFO_MSGS_IGNORE) {
                if (!tresosMsgCategory.equals(category)) continue;
                priority = Priority.LOW;
                message = "really unimportant tresos message";
                fileName = "unimportant.file";
                lineNumber = 1;
                break;
            }
        } else {
            priority = Priority.HIGH;
        }
        return this.createWarning(fileName, lineNumber, category, message, priority);
    }
}

