/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpDocumentParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

@Extension
public class EclipseParser
extends RegexpDocumentParser {
    private static final long serialVersionUID = 425883472788422955L;
    private static final String ANT_ECLIPSE_WARNING_PATTERN = "\\[?(WARNING|ERROR)\\]?\\s*(?:in)?\\s*(.*)(?:\\(at line\\s*(\\d+)\\)|:\\[(\\d+)).*(?:\\r?\\n[^\\^\\n]*){1,3}\\r?\\n(.*)([\\^]+).*\\r?\\n(?:\\s*\\[.*\\]\\s*)?(.*)";

    public EclipseParser() {
        super(Messages._Warnings_EclipseParser_ParserName(), Messages._Warnings_EclipseParser_LinkName(), Messages._Warnings_EclipseParser_TrendName(), ANT_ECLIPSE_WARNING_PATTERN, true);
    }

    @Override
    protected String getId() {
        return "Eclipse Java Compiler";
    }

    @Override
    public String getSmallImage() {
        return "/plugin/warnings/icons/java-24x24.png";
    }

    @Override
    public String getLargeImage() {
        return "/plugin/warnings/icons/java-48x48.png";
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String type = StringUtils.capitalize((String)matcher.group(1));
        Priority priority = "warning".equalsIgnoreCase(type) ? Priority.NORMAL : Priority.HIGH;
        Warning warning = this.createWarning(matcher.group(2), this.getLineNumber(this.getLine(matcher)), matcher.group(7), priority);
        int columnStart = StringUtils.defaultString((String)matcher.group(5)).length();
        int columnEnd = columnStart + matcher.group(6).length();
        warning.setColumnPosition(columnStart, columnEnd);
        return warning;
    }

    private String getLine(Matcher matcher) {
        String eclipse34 = matcher.group(3);
        String eclipse38 = matcher.group(4);
        return StringUtils.defaultIfEmpty((String)eclipse34, (String)eclipse38);
    }
}

