/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class ErlcParser
extends RegexpLineParser {
    private static final long serialVersionUID = 8986478184830773892L;
    private static final String ERLC_WARNING_PATTERN = "^(.+\\.(?:erl|yrl|mib|bin|rel|asn1|idl)):(\\d*): ([wW]arning: )?(.+)$";

    public ErlcParser() {
        super(Messages._Warnings_Erlang_ParserName(), Messages._Warnings_Erlang_LinkName(), Messages._Warnings_Erlang_TrendName(), ERLC_WARNING_PATTERN);
    }

    @Override
    protected String getId() {
        return "Erlang Compiler";
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String category;
        Priority priority;
        String filename = matcher.group(1);
        int linenumber = this.getLineNumber(matcher.group(2));
        String message = matcher.group(4);
        String categoryMatch = matcher.group(3);
        if ("warning: ".equalsIgnoreCase(categoryMatch)) {
            priority = Priority.NORMAL;
            category = categoryMatch.substring(0, categoryMatch.length() - 2);
        } else {
            priority = Priority.HIGH;
            category = "Error";
        }
        return this.createWarning(filename, linenumber, category, message, priority);
    }
}

