/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.ParserRegistry;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;

public class FileWarningsParser
implements AnnotationParser {
    private static final long serialVersionUID = -262047528431480332L;
    @SuppressFBWarnings(value={"Se"})
    private final List<AbstractWarningsParser> parsers;
    private final String defaultEncoding;

    public FileWarningsParser(List<AbstractWarningsParser> parsers, String defaultEncoding) {
        this.parsers = parsers;
        this.defaultEncoding = defaultEncoding;
    }

    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        try {
            Collection<FileAnnotation> annotations = new ParserRegistry(this.parsers, this.defaultEncoding).parse(file);
            for (FileAnnotation annotation : annotations) {
                annotation.setModuleName(moduleName);
            }
            return annotations;
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception, "Can't scan file for warnings: " + file.getAbsolutePath());
        }
    }
}

