/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class GnuMakeGccParser
extends RegexpLineParser {
    private static final String SLASH = "/";
    private static final long serialVersionUID = -67701741403245309L;
    private static final String ERROR = "error";
    static final String GCC_ERROR = "GCC error";
    static final String LINKER_ERROR = "Linker error";
    private static final String GNUMAKEGCC_WARNING_PATTERN = "^((?:.*\\[.*\\])?\\s*(.*\\.[chpimxsola0-9]+):(\\d+):(?:\\d+:)? (warning|error): (.*)$)|((^g?make(\\[.*\\])?: Entering directory)\\s*(['`]((.*))\\'))";
    private String directory = "";
    private boolean isWindows;

    public GnuMakeGccParser() {
        this(System.getProperty("os.name"));
    }

    public GnuMakeGccParser(String os) {
        super(Messages._Warnings_GnuMakeGcc_ParserName(), Messages._Warnings_GnuMakeGcc_LinkName(), Messages._Warnings_GnuMakeGcc_TrendName(), GNUMAKEGCC_WARNING_PATTERN);
        this.isWindows = os.toLowerCase().contains("windows");
    }

    @Override
    protected String getId() {
        return "GNU Make + GNU Compiler (gcc)";
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        if (matcher.group(1) == null) {
            return this.handleDirectory(matcher);
        }
        return this.handleWarning(matcher);
    }

    private Warning handleWarning(Matcher matcher) {
        String category;
        Priority priority;
        String fileName = matcher.group(2);
        int lineNumber = this.getLineNumber(matcher.group(3));
        String message = matcher.group(5);
        if (ERROR.equalsIgnoreCase(matcher.group(4))) {
            priority = Priority.HIGH;
            category = "Error";
        } else {
            priority = Priority.NORMAL;
            category = "Warning";
        }
        if (fileName.startsWith(SLASH)) {
            return this.createWarning(fileName, lineNumber, category, message, priority);
        }
        return this.createWarning(this.directory + fileName, lineNumber, category, message, priority);
    }

    private String fixMsysTypeDirectory(String directory) {
        if (this.isWindows && directory.matches("/[a-z]/.*")) {
            directory = directory.substring(1, 2) + ":" + directory.substring(2);
        }
        return directory;
    }

    private Warning handleDirectory(Matcher matcher) {
        this.directory = matcher.group(10) + SLASH;
        this.directory = this.fixMsysTypeDirectory(this.directory);
        return FALSE_POSITIVE;
    }
}

