/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

@Extension
public class IarParser
extends RegexpLineParser {
    private static final long serialVersionUID = 7695540852439013425L;
    private static final int GROUP_NUMBER = 5;
    private static final String IAR_WARNING_PATTERN = "((\\[exec\\] )?(.*)\\((\\d+)\\)?.*)?(Fatal [Ee]rror|Remark|Warning)\\[(\\w+)\\]: (.*(\\\".*(c|h)\\\")|.*)";

    public IarParser() {
        super(Messages._Warnings_iar_ParserName(), Messages._Warnings_iar_LinkName(), Messages._Warnings_iar_TrendName(), IAR_WARNING_PATTERN, true);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("Warning") || line.contains("rror") || line.contains("Remark") || line.contains("[");
    }

    @Override
    protected String getId() {
        return "IAR compiler (C/C++)";
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        Priority priority = this.determinePriority(matcher.group(5));
        return this.composeWarning(matcher, priority);
    }

    private Warning composeWarning(Matcher matcher, Priority priority) {
        String message = matcher.group(7);
        if (matcher.group(3) == null) {
            return this.createWarning(StringUtils.defaultString((String)matcher.group(8)), 0, matcher.group(6), message, priority);
        }
        return this.createWarning(matcher.group(3), this.getLineNumber(matcher.group(4)), matcher.group(6), message, priority);
    }

    private Priority determinePriority(String message) {
        if (message.toLowerCase().contains("error")) {
            return Priority.HIGH;
        }
        if (message.toLowerCase().contains("warning")) {
            return Priority.NORMAL;
        }
        return Priority.LOW;
    }
}

