/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.util.XmlElementUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Extension
public class IdeaInspectionParser
extends AbstractWarningsParser {
    private static final long serialVersionUID = 3307389086106375473L;
    private static final String IDEA_SMALL_ICON = "/plugin/warnings/icons/idea-24x24.png";
    private static final String IDEA_LARGE_ICON = "/plugin/warnings/icons/idea-48x48.png";

    public IdeaInspectionParser() {
        super(Messages._Warnings_IdeaInspection_ParserName(), Messages._Warnings_IdeaInspection_LinkName(), Messages._Warnings_IdeaInspection_TrendName());
    }

    @Override
    public Collection<FileAnnotation> parse(Reader reader) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            Element rootElement = (Element)document.getElementsByTagName("problems").item(0);
            return this.parseProblems(XmlElementUtil.getNamedChildElements(rootElement, "problem"));
        }
        catch (ParserConfigurationException exception) {
            throw new IOException(exception);
        }
        catch (SAXException exception) {
            throw new IOException(exception);
        }
    }

    private List<FileAnnotation> parseProblems(List<Element> elements) {
        ArrayList problems = Lists.newArrayList();
        for (Element element : elements) {
            String file = this.getChildValue(element, "file");
            int line = Integer.parseInt(this.getChildValue(element, "line"));
            Element problemClass = XmlElementUtil.getFirstElementByTagName(element, "problem_class");
            String severity = problemClass.getAttribute("severity");
            String category = StringEscapeUtils.unescapeXml((String)this.getValue(problemClass));
            String description = StringEscapeUtils.unescapeXml((String)this.getChildValue(element, "description"));
            problems.add(this.createWarning(file, line, category, description, this.getPriority(severity)));
        }
        return problems;
    }

    private Priority getPriority(String severity) {
        Priority priority = Priority.LOW;
        if (severity.equals("WARNING")) {
            priority = Priority.NORMAL;
        } else if (severity.equals("ERROR")) {
            priority = Priority.HIGH;
        }
        return priority;
    }

    private String getValue(Element element) {
        return element.getFirstChild().getNodeValue();
    }

    private String getChildValue(Element element, String childTag) {
        Node child;
        Element firstElement = XmlElementUtil.getFirstElementByTagName(element, childTag);
        if (firstElement != null && (child = firstElement.getFirstChild()) != null) {
            return child.getNodeValue();
        }
        return "-";
    }

    @Override
    protected String getId() {
        return "IntelliJ IDEA Inspections";
    }

    @Override
    public String getSmallImage() {
        return IDEA_SMALL_ICON;
    }

    @Override
    public String getLargeImage() {
        return IDEA_LARGE_ICON;
    }
}

