/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.Localizable;

@Extension
public class IntelParser
extends RegexpLineParser {
    private static final long serialVersionUID = 8409744276858003050L;
    private static final String INTEL_PATTERN = "^(.*)\\((\\d*)\\)?:(?:\\s*\\(col\\. (\\d+)\\))?.*((?:remark|warning|error)\\s*#*\\d*)\\s*:\\s*(.*)$";

    public IntelParser() {
        this(Messages._Warnings_IntelC_ParserName(), Messages._Warnings_IntelC_LinkName(), Messages._Warnings_IntelC_TrendName());
    }

    public IntelParser(Localizable parserName, Localizable linkName, Localizable trendName) {
        super(parserName, linkName, trendName, INTEL_PATTERN, true);
    }

    @Override
    protected String getId() {
        return "Intel compiler";
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("warning") || line.contains("error") || line.contains("remark");
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String category = StringUtils.capitalize((String)matcher.group(4));
        Priority priority = StringUtils.startsWith((String)category, (String)"Remark") ? Priority.LOW : (StringUtils.startsWith((String)category, (String)"Error") ? Priority.HIGH : Priority.NORMAL);
        Warning warning = this.createWarning(matcher.group(1), this.getLineNumber(matcher.group(2)), category, matcher.group(5), priority);
        warning.setColumnPosition(this.getLineNumber(matcher.group(3)));
        return warning;
    }
}

