/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JSLintXMLSaxParser
extends DefaultHandler {
    private final List<FileAnnotation> warnings;
    private String fileName;
    private final String type;
    static final String CATEGORY_PARSING = "Parsing";
    static final String CATEGORY_UNDEFINED_VARIABLE = "Undefined Variable";
    static final String CATEGORY_FORMATTING = "Formatting";

    public JSLintXMLSaxParser(String type, List<FileAnnotation> warnings) {
        this.type = type;
        this.warnings = warnings;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String key = qName;
        if (this.isLintDerivate(key)) {
            return;
        }
        if ("file".equals(key)) {
            this.fileName = atts.getValue("name");
            return;
        }
        if ("issue".equals(key) || "error".equals(key)) {
            this.createWarning(atts);
        }
    }

    private void createWarning(Attributes attributes) {
        String category = "";
        Priority priority = Priority.NORMAL;
        String message = this.extractFrom(attributes, "reason", "message");
        if (message.startsWith("Expected")) {
            priority = Priority.HIGH;
            category = CATEGORY_PARSING;
        } else if (message.endsWith(" is not defined.")) {
            priority = Priority.HIGH;
            category = CATEGORY_UNDEFINED_VARIABLE;
        } else if (message.contains("Mixed spaces and tabs")) {
            priority = Priority.LOW;
            category = CATEGORY_FORMATTING;
        } else if (message.contains("Unnecessary semicolon")) {
            category = CATEGORY_FORMATTING;
        } else if (message.contains("is better written in dot notation")) {
            category = CATEGORY_FORMATTING;
        }
        int lineNumber = AbstractWarningsParser.convertLineNumber(attributes.getValue("line"));
        Warning warning = new Warning(this.fileName, lineNumber, this.type, category, message, priority);
        String column = this.extractFrom(attributes, "column", "char");
        if (StringUtils.isNotBlank((String)column)) {
            warning.setColumnPosition(AbstractWarningsParser.convertLineNumber(column));
        }
        this.warnings.add((FileAnnotation)warning);
    }

    private String extractFrom(Attributes atts, String first, String second) {
        String value = atts.getValue(first);
        if (StringUtils.isEmpty((String)value)) {
            value = atts.getValue(second);
        }
        return value;
    }

    private boolean isLintDerivate(String key) {
        return key != null && key.contains("lint");
    }
}

