/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.console.ConsoleNote;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.plugins.warnings.parser.RegexpParser;
import hudson.plugins.warnings.parser.Warning;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Extension
public class LinuxKernelOutputParser
extends RegexpParser {
    private static final long serialVersionUID = 7580943036264863780L;
    private static final String PREAMBLE = "(?s)";
    private static final String KERN_TIMESTAMP = "\\[[ ]*[0-9]+\\.[0-9]+\\]";
    private static final String BUGWARN_START = " ------------\\[ cut here \\]------------";
    private static final String BUGWARN_END = " ---\\[ end trace [0-9a-fA-F]+ \\]---";
    private static final String BUGWARN = "(\\[[ ]*[0-9]+\\.[0-9]+\\]) ------------\\[ cut here \\]------------(.*?)\\[[ ]*[0-9]+\\.[0-9]+\\]( ---\\[ end trace [0-9a-fA-F]+ \\]---)";
    private static final String KERNOUTPUT = "(\\[[ ]*[0-9]+\\.[0-9]+\\])([^\n]*)";
    private static final String LINUX_KERNEL_OUTPUT_WARNING_PATTERN = "(?s)((\\[[ ]*[0-9]+\\.[0-9]+\\]) ------------\\[ cut here \\]------------(.*?)\\[[ ]*[0-9]+\\.[0-9]+\\]( ---\\[ end trace [0-9a-fA-F]+ \\]---)|(\\[[ ]*[0-9]+\\.[0-9]+\\])([^\n]*))";
    private static final String KERNOUTPUT_PATERN = "(?s)(\\[[ ]*[0-9]+\\.[0-9]+\\])([^\n]*)";
    private static final String BUGWARN_START_PATERN = "(?s)\\[[ ]*[0-9]+\\.[0-9]+\\] ------------\\[ cut here \\]------------";
    private static final String BUGWARN_END_PATERN = "(?s)\\[[ ]*[0-9]+\\.[0-9]+\\] ---\\[ end trace [0-9a-fA-F]+ \\]---";
    private static final int ALL_OUTPUT = 1;
    private static final int BUGWARN_TIMESTAMP = 2;
    private static final int BUGWARN_CONTENT = 3;
    private static final int BUGWARN_ENDTRACE = 4;
    private static final int KERNOUTPUT_TIMESTAMP = 5;
    private static final int KERNOUTPUT_CONTENT = 6;
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("(BUG|WARNING)[^/]*at[ ](((?:[^/]*/)*.*):(\\d+))?([^+!]*)");
    private static final int ERROR_TYPE = 1;
    private static final int ERROR_INTERNAL = 2;
    private static final int ERROR_PATH = 3;
    private static final int ERROR_LINE = 4;
    private static final int ERROR_FUNC = 5;

    public LinuxKernelOutputParser() {
        super(Messages._Warnings_LinuxKernelOutput_ParserName(), Messages._Warnings_LinuxKernelOutput_LinkName(), Messages._Warnings_LinuxKernelOutput_TrendName(), LINUX_KERNEL_OUTPUT_WARNING_PATTERN, false);
    }

    @Override
    public Collection<FileAnnotation> parse(Reader file) throws IOException, ParsingCanceledException {
        ArrayList<FileAnnotation> warnings = new ArrayList<FileAnnotation>();
        BufferedReader reader = new BufferedReader(file);
        String line = reader.readLine();
        Pattern pBugStart = Pattern.compile(BUGWARN_START_PATERN);
        Pattern pBugEnd = Pattern.compile(BUGWARN_END_PATERN);
        Pattern pOutput = Pattern.compile(KERNOUTPUT_PATERN);
        while (line != null) {
            Matcher m = pBugStart.matcher(line);
            if (m.matches()) {
                StringBuilder buf = new StringBuilder();
                do {
                    buf.append(ConsoleNote.removeNotes((String)line)).append('\n');
                } while (!(m = pBugEnd.matcher(line = reader.readLine())).matches());
                buf.append(ConsoleNote.removeNotes((String)line)).append('\n');
                this.findAnnotations(buf.toString(), warnings);
                line = reader.readLine();
                continue;
            }
            m = pOutput.matcher(line);
            if (m.matches()) {
                this.findAnnotations(ConsoleNote.removeNotes((String)line), warnings);
            }
            line = reader.readLine();
        }
        file.close();
        return warnings;
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder toolTipBuilder = new StringBuilder();
        String filePath = "Nil";
        int lineNumber = 0;
        String category = "Kernel Output";
        Priority priority = Priority.LOW;
        String bug = matcher.group(3);
        String kern = matcher.group(6);
        if (kern != null) {
            String stripped = kern.replaceAll(KERN_TIMESTAMP, "").trim();
            messageBuilder.append(stripped);
        } else if (bug != null) {
            Matcher pathMatcher = FILE_PATH_PATTERN.matcher(bug);
            if (pathMatcher.find()) {
                category = pathMatcher.group(1).trim();
                filePath = pathMatcher.group(3).trim();
                lineNumber = this.getLineNumber(pathMatcher.group(4));
                priority = "BUG".equals(category) ? Priority.HIGH : Priority.NORMAL;
                messageBuilder.append(category);
                messageBuilder.append(" in ");
                messageBuilder.append(pathMatcher.group(5).trim());
                messageBuilder.append("()");
                toolTipBuilder.append("------------[ cut here ]------------\n");
                toolTipBuilder.append(bug.replaceAll("(\\[[ ]*[0-9]+\\.[0-9]+\\])", "").trim());
                toolTipBuilder.append("\n");
                toolTipBuilder.append(matcher.group(4));
                toolTipBuilder.append("\n");
            } else {
                messageBuilder.append(bug.replaceAll("(\\[[ ]*[0-9]+\\.[0-9]+\\])", "").trim());
            }
        } else {
            return FALSE_POSITIVE;
        }
        String message = messageBuilder.length() == 0 ? "Unknown Error" : messageBuilder.toString().replace("\n", "<br>");
        Warning warning = this.createWarning(filePath, lineNumber, category, message, priority);
        if (toolTipBuilder.length() > 0) {
            String toolTip = toolTipBuilder.toString().replace("\n", "<br>");
            warning.setToolTip(toolTip);
        }
        return warning;
    }
}

