/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class MetrowerksCWLinkerParser
extends RegexpLineParser {
    private static final String CW_LINKER_WARNING_PATTERN = "^(INFORMATION|WARNING|ERROR) (.+)$";

    public MetrowerksCWLinkerParser() {
        super(Messages._Warnings_MetrowerksCWLinker_ParserName(), Messages._Warnings_MetrowerksCWLinker_LinkName(), Messages._Warnings_MetrowerksCWLinker_TrendName(), CW_LINKER_WARNING_PATTERN);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String category;
        Priority priority;
        String message = matcher.group(2);
        String message_category = matcher.group(1);
        if ("error".equalsIgnoreCase(message_category)) {
            priority = Priority.HIGH;
            category = "ERROR";
        } else if ("information".equalsIgnoreCase(message_category)) {
            priority = Priority.LOW;
            category = "Info";
        } else {
            priority = Priority.NORMAL;
            category = "Warning";
        }
        return this.createWarning("See Warning message", 0, category, message, priority);
    }
}

