/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.Localizable;

@Extension
public class MsBuildParser
extends RegexpLineParser {
    private static final long serialVersionUID = -2141974437420906595L;
    static final String WARNING_TYPE = "MSBuild";
    private static final String MS_BUILD_WARNING_PATTERN = "(?:^(?:.*)Command line warning ([A-Za-z0-9]+):\\s*(.*)\\s*\\[(.*)\\])|^(?:.*\\[.*\\])?\\s*(?:(?:\\s*\\d+>)?(?:(?:(?:(.*)\\((\\d*)(?:,(\\d+))?.*\\)|.*LINK)\\s*:|(.*):)\\s*([A-z-_]*\\s?(?:[Nn]ote|[Ii]nfo|[Ww]arning|(?:fatal\\s*)?[Ee]rror))\\s*:?\\s*([A-Za-z0-9\\-_]+)\\s*:\\s(?:\\s*([A-Za-z0-9.]+)\\s*:)?\\s*(.*?)(?: \\[([^\\]]*)[/\\\\][^\\]\\\\]+\\])?|(.*)\\s*:.*error\\s*(LNK[0-9]+):\\s*(.*)))$";

    public MsBuildParser() {
        this(Messages._Warnings_MSBuild_ParserName(), Messages._Warnings_MSBuild_LinkName(), Messages._Warnings_MSBuild_TrendName());
    }

    public MsBuildParser(Localizable parserName, Localizable linkName, Localizable trendName) {
        super(parserName, linkName, trendName, MS_BUILD_WARNING_PATTERN);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        Warning warning;
        String fileName = this.determineFileName(matcher);
        if (StringUtils.isNotBlank((String)matcher.group(2))) {
            return this.createWarning(fileName, 0, matcher.group(1), matcher.group(2), Priority.NORMAL);
        }
        if (StringUtils.isNotBlank((String)matcher.group(13))) {
            return this.createWarning(fileName, 0, matcher.group(14), matcher.group(15), Priority.HIGH);
        }
        if (StringUtils.isNotEmpty((String)matcher.group(10))) {
            warning = this.createWarning(fileName, this.getLineNumber(matcher.group(5)), matcher.group(10), matcher.group(9), matcher.group(11), this.determinePriority(matcher));
        } else {
            String category = matcher.group(9);
            if ("Expected".matches(category)) {
                return FALSE_POSITIVE;
            }
            warning = this.createWarning(fileName, this.getLineNumber(matcher.group(5)), category, matcher.group(11), this.determinePriority(matcher));
        }
        warning.setColumnPosition(this.getLineNumber(matcher.group(6)));
        return warning;
    }

    private String determineFileName(Matcher matcher) {
        String projectDir;
        String fileName = StringUtils.isNotBlank((String)matcher.group(3)) ? matcher.group(3) : (StringUtils.isNotBlank((String)matcher.group(7)) ? matcher.group(7) : (StringUtils.isNotBlank((String)matcher.group(13)) ? matcher.group(13) : matcher.group(4)));
        if (StringUtils.isBlank((String)fileName)) {
            fileName = StringUtils.substringBetween((String)matcher.group(11), (String)"'");
        }
        if (StringUtils.isBlank((String)fileName)) {
            fileName = "unknown.file";
        }
        if (StringUtils.isNotBlank((String)(projectDir = matcher.group(12))) && FilenameUtils.getPrefixLength((String)fileName) == 0 && !fileName.trim().equals("MSBUILD")) {
            fileName = FilenameUtils.concat((String)projectDir, (String)fileName);
        }
        return fileName;
    }

    private Priority determinePriority(Matcher matcher) {
        if (this.isOfType(matcher, "note") || this.isOfType(matcher, "info")) {
            return Priority.LOW;
        }
        if (this.isOfType(matcher, "warning")) {
            return Priority.NORMAL;
        }
        return Priority.HIGH;
    }

    private boolean isOfType(Matcher matcher, String type) {
        return StringUtils.containsIgnoreCase((String)matcher.group(8), (String)type);
    }
}

