/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpDocumentParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

@Extension
public class NagFortranParser
extends RegexpDocumentParser {
    private static final long serialVersionUID = 0L;
    private static final String NAGFOR_MSG_PATTERN = "^(Info|Warning|Questionable|Extension|Obsolescent|Deleted feature used|Error|Runtime Error|Fatal Error|Panic): (.+\\.[^,:\\n]+)(, line (\\d+))?: (.+($\\s+detected at .+)?)";

    public NagFortranParser() {
        super(Messages._Warnings_NagFortran_ParserName(), Messages._Warnings_NagFortran_LinkName(), Messages._Warnings_NagFortran_TrendName(), NAGFOR_MSG_PATTERN, true);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String category = matcher.group(1);
        int lineNumber = StringUtils.isEmpty((String)matcher.group(4)) ? 0 : Integer.parseInt(matcher.group(4));
        Priority priority = "Error".equals(category) || "Runtime Error".equals(category) || "Fatal Error".equals(category) || "Panic".equals(category) ? Priority.HIGH : ("Info".equals(category) ? Priority.LOW : Priority.NORMAL);
        return this.createWarning(matcher.group(2), lineNumber, category, matcher.group(5), priority);
    }

    @Override
    protected String getId() {
        return "NAG Fortran Compiler (nagfor)";
    }
}

