/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class P4Parser
extends RegexpLineParser {
    private static final long serialVersionUID = -8106854254745366432L;
    private static final String ALREADY_OPENED = "already opened for edit";
    private static final String CANT_ADD = "can't add existing file";
    private static final String WARNING_ADD_OF = "warning: add of existing file";
    private static final String OPENED_FOR_EDIT = "can't add \\(already opened for edit\\)";
    private static final String NOTHING_CHANGED = "nothing changed";
    private static final String OR = "|";
    private static final String PERFORCE_WARNING_PATTERN = "^(.*) - (can't add existing file|warning: add of existing file|can't add \\(already opened for edit\\)|nothing changed)(.*)$";

    public P4Parser() {
        super(Messages._Warnings_Perforce_ParserName(), Messages._Warnings_Perforce_LinkName(), Messages._Warnings_Perforce_TrendName(), PERFORCE_WARNING_PATTERN, true);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String fileName;
        String category = matcher.group(2).trim();
        String message = fileName = matcher.group(1).trim();
        Priority p = Priority.NORMAL;
        if (category.contains(ALREADY_OPENED) || category.equals(NOTHING_CHANGED)) {
            p = Priority.LOW;
        }
        return this.createWarning(fileName, 0, category, message, p);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains(" - ");
    }
}

