/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class Pep8Parser
extends RegexpLineParser {
    private static final long serialVersionUID = -8444940209330966997L;
    private static final String PEP8_WARNING_PATTERN = "(.*):(\\d+):(\\d+): (\\D\\d*) (.*)";

    public Pep8Parser() {
        super(Messages._Warnings_Pep8_ParserName(), Messages._Warnings_Pep8_LinkName(), Messages._Warnings_Pep8_TrendName(), PEP8_WARNING_PATTERN, true);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String message = matcher.group(5);
        String category = this.classifyIfEmpty(matcher.group(4), message);
        Warning warning = this.createWarning(matcher.group(1), this.getLineNumber(matcher.group(2)), category, message, this.mapPriority(category));
        warning.setColumnPosition(this.getLineNumber(matcher.group(3)));
        return warning;
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains(":");
    }

    private Priority mapPriority(String priority) {
        if (priority.contains("E")) {
            return Priority.NORMAL;
        }
        return Priority.LOW;
    }
}

