/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class PhpParser
extends RegexpLineParser {
    private static final long serialVersionUID = -5154327854315791181L;
    private static final String PHP_WARNING_PATTERN = "^.*(PHP Warning|PHP Notice|PHP Fatal error|PHP Parse error):\\s+(?:(.+ in (.+) on line (\\d+))|(SOAP-ERROR:\\s+.*))$";

    public PhpParser() {
        super(Messages._Warnings_PHP_ParserName(), Messages._Warnings_PHP_LinkName(), Messages._Warnings_PHP_TrendName(), PHP_WARNING_PATTERN, true);
    }

    @Override
    protected String getId() {
        return "PHP Runtime Warning";
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("PHP");
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String category = matcher.group(1);
        Priority priority = Priority.NORMAL;
        if (category.contains("Fatal") || category.contains("Parse")) {
            priority = Priority.HIGH;
        }
        if (matcher.group(5) != null) {
            return this.createWarning("-", 0, category, matcher.group(5), priority);
        }
        String message = matcher.group(2);
        String fileName = matcher.group(3);
        String start = matcher.group(4);
        return this.createWarning(fileName, Integer.parseInt(start), category, message, priority);
    }
}

