/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class PyLintParser
extends RegexpLineParser {
    private static final long serialVersionUID = 4464053085862883240L;
    private static final String PYLINT_ERROR_PATTERN = "(.*):(\\d+): \\[(\\D\\d*).*\\] (.*)";

    public PyLintParser() {
        super(Messages._Warnings_PyLint_ParserName(), Messages._Warnings_PyLint_LinkName(), Messages._Warnings_PyLint_TrendName(), PYLINT_ERROR_PATTERN, true);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("[");
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String message = matcher.group(4);
        String category = this.classifyIfEmpty(matcher.group(3), message);
        Priority priority = Priority.LOW;
        switch (category.charAt(0)) {
            case 'C': 
            case 'R': {
                priority = Priority.LOW;
                break;
            }
            case 'W': {
                priority = Priority.NORMAL;
                break;
            }
            case 'E': 
            case 'F': {
                priority = Priority.HIGH;
            }
        }
        return this.createWarning(matcher.group(1), this.getLineNumber(matcher.group(2)), category, message, priority);
    }
}

