/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

@Extension
public class RTTestsParser
extends RegexpLineParser {
    private static final long serialVersionUID = 2993328034978892249L;
    private static final String CYCLICTEST_WARNING_PATTERN = "^(WARN(ING)?|FATAL):(.*)$";

    public RTTestsParser() {
        super(Messages._Warnings_RTTests_ParserName(), Messages._Warnings_RTTests_LinkName(), Messages._Warnings_RTTests_TrendName(), CYCLICTEST_WARNING_PATTERN);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String category = StringUtils.trim((String)matcher.group(1));
        String message = StringUtils.trim((String)matcher.group(3));
        Priority priority = Priority.NORMAL;
        if (category == null | message == null) {
            return FALSE_POSITIVE;
        }
        if ("FATAL".equals(category)) {
            priority = Priority.HIGH;
        }
        return this.createWarning("Nil", 0, category, message, priority);
    }
}

