/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.console.ConsoleNote;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.plugins.warnings.parser.RegexpParser;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.jvnet.localizer.Localizable;

public abstract class RegexpLineParser
extends RegexpParser {
    private static final long serialVersionUID = 5932670979793111138L;
    private final boolean isStringMatchActivated;
    private int currentLine;

    public RegexpLineParser(Localizable parserName, Localizable linkName, Localizable trendName, String warningPattern, boolean isStringMatchActivated) {
        super(parserName, linkName, trendName, warningPattern, false);
        this.isStringMatchActivated = isStringMatchActivated;
    }

    public RegexpLineParser(Localizable parserName, Localizable linkName, Localizable trendName, String warningPattern) {
        this(parserName, linkName, trendName, warningPattern, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<FileAnnotation> parse(Reader file) throws IOException, ParsingCanceledException {
        ArrayList<FileAnnotation> warnings = new ArrayList<FileAnnotation>();
        try (LineIterator iterator = IOUtils.lineIterator((Reader)file);){
            this.currentLine = 0;
            if (this.isStringMatchActivated) {
                while (iterator.hasNext()) {
                    String line = this.getNextLine(iterator);
                    if (this.isLineInteresting(line)) {
                        this.findAnnotations(line, warnings);
                    }
                    ++this.currentLine;
                }
            } else {
                while (iterator.hasNext()) {
                    this.findAnnotations(this.getNextLine(iterator), warnings);
                    ++this.currentLine;
                }
            }
        }
        return this.postProcessWarnings(warnings);
    }

    protected Collection<FileAnnotation> postProcessWarnings(List<FileAnnotation> warnings) {
        return warnings;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    private String getNextLine(LineIterator iterator) {
        return ConsoleNote.removeNotes((String)iterator.nextLine());
    }

    protected boolean isLineInteresting(String line) {
        return true;
    }

    @Deprecated
    public RegexpLineParser(String warningPattern, String name) {
        this(warningPattern, name, false);
    }

    @Deprecated
    public RegexpLineParser(String warningPattern, String name, boolean isStringMatchActivated) {
        super(warningPattern, name);
        this.isStringMatchActivated = isStringMatchActivated;
    }
}

