/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.util.XmlElementUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jvnet.localizer.Localizable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Extension
public class ResharperInspectCodeParser
extends RegexpLineParser {
    private static final String RESHAPER_SMALL_ICON = "/plugin/warnings/icons/resharper-24x24.png";
    private static final String RESHAPER_LARGE_ICON = "/plugin/warnings/icons/resharper-48x48.png";
    private static final long serialVersionUID = 526872513348892L;
    private static final String WARNING_TYPE = "ResharperInspectCode";
    private static final String WARNING_PATTERN = "\\<Issue.*?TypeId=\"(.*?)\".*?File=\"(.*?)\".*?Line=\"(.*?)\".*?Message=\"(.*?)\"";
    private final Map<String, Priority> priorityByTypeId = new HashMap<String, Priority>();

    public ResharperInspectCodeParser() {
        this(Messages._Warnings_ReshaperInspectCode_ParserName(), Messages._Warnings_ReshaperInspectCode_LinkName(), Messages._Warnings_ReshaperInspectCode_TrendName());
    }

    public ResharperInspectCodeParser(Localizable parserName, Localizable linkName, Localizable trendName) {
        super(parserName, linkName, trendName, WARNING_PATTERN, true);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        return this.createWarning(matcher.group(2), this.getLineNumber(matcher.group(3)), WARNING_TYPE, matcher.group(1), matcher.group(4), this.GetPriority(matcher.group(1)));
    }

    @Override
    protected String getId() {
        return "Reshaper InspectCode";
    }

    @Override
    public String getSmallImage() {
        return RESHAPER_SMALL_ICON;
    }

    @Override
    public String getLargeImage() {
        return RESHAPER_LARGE_ICON;
    }

    @Override
    protected boolean isLineInteresting(String line) {
        if (line.contains("<IssueType Id=")) {
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader("<IssueTypes>" + line + "</IssueTypes>"));
                Document doc = docBuilder.parse(is);
                NodeList mainNode = doc.getElementsByTagName("IssueTypes");
                Element issueTypesElement = (Element)mainNode.item(0);
                this.parseIssueTypes(XmlElementUtil.getNamedChildElements(issueTypesElement, "IssueType"));
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return line.contains("<Issue");
    }

    private void parseIssueTypes(List<Element> issueTypeElements) {
        for (Element issueTypeElement : issueTypeElements) {
            String id = issueTypeElement.getAttribute("Id");
            if ("".equals(id)) continue;
            String severity = issueTypeElement.getAttribute("Severity");
            if ("ERROR".equals(severity)) {
                this.priorityByTypeId.put(id, Priority.HIGH);
                continue;
            }
            if ("WARNING".equals(severity)) {
                this.priorityByTypeId.put(id, Priority.NORMAL);
                continue;
            }
            if (!"SUGGESTION".equals(severity)) continue;
            this.priorityByTypeId.put(id, Priority.LOW);
        }
    }

    private Priority GetPriority(String typeId) {
        if (this.priorityByTypeId.containsKey(typeId)) {
            return this.priorityByTypeId.get(typeId);
        }
        return Priority.NORMAL;
    }
}

