/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;

@Extension
public class TaskingVXCompilerParser
extends RegexpLineParser {
    private static final String TASKING_VX_COMPILER_WARNING_PATTERN = "^.*? (I|W|E|F)(\\d+): (?:\\[\"(.*?)\" (\\d+)\\/(\\d+)\\] )?(.*)$";

    public TaskingVXCompilerParser() {
        super(Messages._Warnings_TaskingVXCompiler_ParserName(), Messages._Warnings_TaskingVXCompiler_LinkName(), Messages._Warnings_TaskingVXCompiler_TrendName(), TASKING_VX_COMPILER_WARNING_PATTERN);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String category;
        Priority priority;
        String msgType = matcher.group(1);
        String message = matcher.group(6);
        String fileName = matcher.group(3) != null ? matcher.group(3) : "";
        int lineNumber = matcher.group(4) != null ? this.getLineNumber(matcher.group(4)) : 0;
        if ("E".equals(msgType)) {
            priority = Priority.HIGH;
            category = "ERROR";
        } else if ("F".equals(msgType)) {
            priority = Priority.HIGH;
            category = "License issue";
        } else if ("I".equals(msgType)) {
            priority = Priority.LOW;
            category = "Info";
        } else {
            priority = Priority.NORMAL;
            category = "Warning";
        }
        return this.createWarning(fileName, lineNumber, category, message, priority);
    }
}

