/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

@Extension
public class TiCcsParser
extends RegexpLineParser {
    private static final long serialVersionUID = -8253481365175984661L;
    private static final String TI_CCS_WARNING_PATTERN = "^((\"(.*)\",\\s*)(line\\s*(\\d+)(\\s*\\(.*\\))?:)?\\s*)?(WARNING|ERROR|remark|warning|(fatal\\s*)?error)(!\\s*at line\\s(\\d+))?\\s*([^:]*)\\s*:\\s*(.*)$";

    public TiCcsParser() {
        super(Messages._Warnings_TexasI_ParserName(), Messages._Warnings_TexasI_LinkName(), Messages._Warnings_TexasI_TrendName(), TI_CCS_WARNING_PATTERN);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String lineNumber;
        Priority priority = this.isOfType(matcher, "remark") ? Priority.LOW : (this.isOfType(matcher, "warning") ? Priority.NORMAL : Priority.HIGH);
        String fileName = matcher.group(3);
        if (StringUtils.isBlank((String)fileName)) {
            fileName = "unknown.file";
        }
        if (StringUtils.isBlank((String)(lineNumber = matcher.group(5)))) {
            lineNumber = matcher.group(10);
        }
        return this.createWarning(fileName, this.getLineNumber(lineNumber), matcher.group(11), matcher.group(12), priority);
    }

    private boolean isOfType(Matcher matcher, String type) {
        return StringUtils.containsIgnoreCase((String)matcher.group(7), (String)type);
    }
}

