/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import com.google.common.collect.Lists;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Severity;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.plugins.warnings.parser.Warning;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.jvnet.localizer.Localizable;

public class ViolationsAdapter
extends AbstractWarningsParser {
    private static final long serialVersionUID = -4655802222866500913L;
    private final ViolationsParser parser;

    public ViolationsAdapter(ViolationsParser parser, Localizable parserName, Localizable linkName, Localizable trendName) {
        super(parserName, linkName, trendName);
        this.parser = parser;
    }

    @Override
    public Collection<FileAnnotation> parse(Reader reader) throws IOException, ParsingCanceledException {
        File temp = this.copyContentToTemporaryFile(reader);
        FullBuildModel model = new FullBuildModel();
        this.parser.parse(model, temp.getParentFile(), temp.getName(), new String[0]);
        return this.convertToWarnings(model);
    }

    private List<FileAnnotation> convertToWarnings(FullBuildModel model) {
        ArrayList warnings = Lists.newArrayList();
        for (FullFileModel fileModel : model.getFileModelMap().values()) {
            for (TreeSet violations : fileModel.getTypeMap().values()) {
                for (Violation violation : violations) {
                    warnings.add(new Warning(this.getPath(fileModel), violation.getLine(), this.getGroup(), "", violation.getMessage(), this.convertSeverity(violation.getSeverity())));
                }
            }
        }
        return warnings;
    }

    private String getPath(FullFileModel fileModel) {
        File sourceFile = fileModel.getSourceFile();
        if (sourceFile != null) {
            return sourceFile.getPath();
        }
        return fileModel.getDisplayName();
    }

    private Priority convertSeverity(String severity) {
        int level = Severity.getSeverityLevel((String)severity);
        if (level < 2) {
            return Priority.HIGH;
        }
        if (level < 4) {
            return Priority.NORMAL;
        }
        return Priority.LOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyContentToTemporaryFile(Reader reader) throws IOException, FileNotFoundException {
        File temp = File.createTempFile("warnings", "log");
        temp.deleteOnExit();
        FileOutputStream output = new FileOutputStream(temp);
        try {
            IOUtils.copy((Reader)reader, (OutputStream)output, (String)"UTF-8");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        return temp;
    }
}

