/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.plugins.analysis.util.model.AbstractAnnotation;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import org.apache.commons.lang.StringUtils;

public class Warning
extends AbstractAnnotation {
    private static final long serialVersionUID = 5171661552905752370L;
    public static final String ORIGIN = "warnings";
    private String toolTip;

    public Warning(String fileName, int start, String type, String category, String message) {
        this(fileName, start, type, category, message, Priority.NORMAL);
    }

    public Warning(String fileName, int start, String type, String category, String message, Priority priority) {
        super(priority, message, start, start, category, type);
        this.setFileName(fileName);
        this.setOrigin(ORIGIN);
    }

    public Warning(FileAnnotation copy, String additionalMessage, int currentLine) {
        super(copy.getPriority(), copy.getMessage() + "\n" + additionalMessage, copy.getPrimaryLineNumber(), currentLine, copy.getCategory(), copy.getType());
        this.setFileName(copy.getFileName());
        this.setOrigin(ORIGIN);
    }

    public Warning(FileAnnotation copy, int currentLine) {
        super(copy.getPriority(), copy.getMessage(), copy.getPrimaryLineNumber(), currentLine, copy.getCategory(), copy.getType());
        this.setFileName(copy.getFileName());
        this.setOrigin(ORIGIN);
    }

    public String getToolTip() {
        return StringUtils.defaultString((String)this.toolTip);
    }

    public void setToolTip(String value) {
        this.toolTip = value;
    }
}

