/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import com.google.common.collect.Sets;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

public class WarningsFilter {
    private final Set<Pattern> includePatterns = Sets.newHashSet();
    private final Set<Pattern> excludePatterns = Sets.newHashSet();

    private Set<Pattern> addFilePatterns(@CheckForNull String pattern) {
        HashSet patterns = Sets.newHashSet();
        if (StringUtils.isNotBlank((String)pattern)) {
            String[] split;
            for (String singlePattern : split = StringUtils.split((String)pattern, (char)',')) {
                String trimmed = StringUtils.trim((String)singlePattern);
                String directoriesReplaced = StringUtils.replace((String)trimmed, (String)"**", (String)"*");
                patterns.add(Pattern.compile(StringUtils.replace((String)directoriesReplaced, (String)"*", (String)".*")));
            }
        }
        return patterns;
    }

    private Set<Pattern> addStringPatterns(@CheckForNull String pattern) {
        HashSet patterns = Sets.newHashSet();
        if (StringUtils.isNotBlank((String)pattern)) {
            String[] split;
            for (String singlePattern : split = StringUtils.split((String)pattern, (char)'\n')) {
                String trimmed = StringUtils.trim((String)singlePattern);
                patterns.add(Pattern.compile(trimmed));
            }
        }
        return patterns;
    }

    public Collection<FileAnnotation> apply(Collection<FileAnnotation> allAnnotations, @CheckForNull String includePattern, @CheckForNull String excludePattern, @CheckForNull String messagesPattern, @CheckForNull String categoriesPattern, PluginLogger logger) {
        HashSet includedAnnotations;
        Set<Pattern> includePatterns = this.addFilePatterns(includePattern);
        Set<Pattern> excludePatterns = this.addFilePatterns(excludePattern);
        Set<Pattern> messagesPatterns = this.addStringPatterns(messagesPattern);
        Set<Pattern> categoriesPatterns = this.addStringPatterns(categoriesPattern);
        if (includePatterns.isEmpty()) {
            includedAnnotations = allAnnotations;
        } else {
            includedAnnotations = Sets.newHashSet();
            for (FileAnnotation annotation : allAnnotations) {
                for (Pattern include : includePatterns) {
                    if (!include.matcher(annotation.getFileName()).matches()) continue;
                    includedAnnotations.add(annotation);
                }
            }
        }
        if (excludePatterns.isEmpty() && messagesPatterns.isEmpty() && categoriesPatterns.isEmpty()) {
            return includedAnnotations;
        }
        HashSet excludedAnnotations = Sets.newHashSet((Iterable)includedAnnotations);
        for (FileAnnotation annotation : includedAnnotations) {
            for (Pattern exclude : excludePatterns) {
                if (!exclude.matcher(annotation.getFileName()).matches()) continue;
                excludedAnnotations.remove(annotation);
            }
            for (Pattern exclude : messagesPatterns) {
                if (!exclude.matcher(annotation.getMessage()).matches()) continue;
                excludedAnnotations.remove(annotation);
            }
            for (Pattern exclude : categoriesPatterns) {
                if (!exclude.matcher(annotation.getCategory()).matches()) continue;
                excludedAnnotations.remove(annotation);
            }
        }
        logger.log(String.format("Found %d warnings after exclusion.", excludedAnnotations.size()));
        return excludedAnnotations;
    }

    public boolean isActive(String includePattern, String excludePattern, String messagesPattern, String categoriesPattern) {
        return StringUtils.isNotBlank((String)includePattern) || StringUtils.isNotBlank((String)excludePattern) || StringUtils.isNotBlank((String)messagesPattern) || StringUtils.isNotBlank((String)categoriesPattern);
    }
}

