/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser.fxcop;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.parser.fxcop.FxCopRule;
import hudson.plugins.warnings.parser.fxcop.FxCopRuleSet;
import hudson.plugins.warnings.util.XmlElementUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Extension
public class FxCopParser
extends AbstractWarningsParser {
    private static final long serialVersionUID = -7208558002331355408L;
    private transient FxCopRuleSet ruleSet;
    @SuppressFBWarnings(value={"SE"})
    private transient List<FileAnnotation> warnings;

    public FxCopParser() {
        super(Messages._Warnings_FxCop_ParserName(), Messages._Warnings_FxCop_LinkName(), Messages._Warnings_FxCop_TrendName());
    }

    @Override
    public Collection<FileAnnotation> parse(Reader reader) throws IOException, ParsingCanceledException {
        try {
            this.ruleSet = new FxCopRuleSet();
            this.warnings = Lists.newArrayList();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(reader));
            NodeList mainNode = doc.getElementsByTagName("FxCopReport");
            Element rootElement = (Element)mainNode.item(0);
            this.parseRules(XmlElementUtil.getFirstElementByTagName(rootElement, "Rules"));
            this.parseNamespaces(XmlElementUtil.getFirstElementByTagName(rootElement, "Namespaces"), null);
            this.parseTargets(XmlElementUtil.getFirstElementByTagName(rootElement, "Targets"));
            return this.warnings;
        }
        catch (ParserConfigurationException exception) {
            throw new IOException(exception);
        }
        catch (SAXException exception) {
            throw new IOException(exception);
        }
    }

    private void parseRules(Element rulesElement) {
        if (rulesElement != null) {
            for (Element rule : XmlElementUtil.getNamedChildElements(rulesElement, "Rule")) {
                this.ruleSet.addRule(rule);
            }
        }
    }

    private void parseTargets(Element targetsElement) {
        if (targetsElement != null) {
            for (Element target : XmlElementUtil.getNamedChildElements(targetsElement, "Target")) {
                String name = this.getString(target, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(target, "Messages"), name);
                this.parseModules(XmlElementUtil.getFirstElementByTagName(target, "Modules"), name);
                this.parseResources(XmlElementUtil.getFirstElementByTagName(target, "Resources"), name);
            }
        }
    }

    private void parseResources(Element resources, String parentName) {
        if (resources != null) {
            for (Element target : XmlElementUtil.getNamedChildElements(resources, "Resource")) {
                String name = this.getString(target, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(target, "Messages"), name);
            }
        }
    }

    private void parseModules(Element modulesElement, String parentName) {
        if (modulesElement != null) {
            for (Element module : XmlElementUtil.getNamedChildElements(modulesElement, "Module")) {
                String name = this.getString(module, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(module, "Messages"), name);
                this.parseNamespaces(XmlElementUtil.getFirstElementByTagName(module, "Namespaces"), name);
            }
        }
    }

    private void parseNamespaces(Element namespacesElement, String parentName) {
        if (namespacesElement != null) {
            for (Element namespace : XmlElementUtil.getNamedChildElements(namespacesElement, "Namespace")) {
                String name = this.getString(namespace, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(namespace, "Messages"), name);
                this.parseTypes(XmlElementUtil.getFirstElementByTagName(namespace, "Types"), name);
            }
        }
    }

    private void parseTypes(Element typesElement, String parentName) {
        if (typesElement != null) {
            for (Element type : XmlElementUtil.getNamedChildElements(typesElement, "Type")) {
                String name = parentName + "." + this.getString(type, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(type, "Messages"), name);
                this.parseMembers(XmlElementUtil.getFirstElementByTagName(type, "Members"), name);
            }
        }
    }

    private void parseMembers(Element membersElement, String parentName) {
        if (membersElement != null) {
            for (Element member : XmlElementUtil.getNamedChildElements(membersElement, "Member")) {
                this.parseMember(member, parentName);
            }
        }
    }

    private void parseAccessors(Element accessorsElement, String parentName) {
        if (accessorsElement != null) {
            for (Element member : XmlElementUtil.getNamedChildElements(accessorsElement, "Accessor")) {
                this.parseMember(member, parentName);
            }
        }
    }

    private void parseMember(Element member, String parentName) {
        this.parseMessages(XmlElementUtil.getFirstElementByTagName(member, "Messages"), parentName);
        this.parseAccessors(XmlElementUtil.getFirstElementByTagName(member, "Accessors"), parentName);
    }

    private void parseMessages(Element messages, String parentName) {
        this.parseMessages(messages, parentName, null);
    }

    private void parseMessages(Element messages, String parentName, String subName) {
        if (messages != null) {
            for (Element message : XmlElementUtil.getNamedChildElements(messages, "Message")) {
                for (Element issue : XmlElementUtil.getNamedChildElements(message, "Issue")) {
                    this.parseIssue(issue, message, parentName, subName);
                }
            }
        }
    }

    private void parseIssue(Element issue, Element parent, String parentName, String subName) {
        FxCopRule rule;
        String typeName = this.getString(parent, "TypeName");
        String category = this.getString(parent, "Category");
        String checkId = this.getString(parent, "CheckId");
        String issueLevel = this.getString(issue, "Level");
        StringBuilder msgBuilder = new StringBuilder();
        if (subName != null) {
            msgBuilder.append(subName);
            msgBuilder.append(' ');
        }
        if ((rule = this.ruleSet.getRule(category, checkId)) == null) {
            msgBuilder.append(typeName);
        } else {
            msgBuilder.append("<a href=\"");
            msgBuilder.append(rule.getUrl());
            msgBuilder.append("\">");
            msgBuilder.append(typeName);
            msgBuilder.append("</a>");
        }
        msgBuilder.append(" - ");
        msgBuilder.append(issue.getTextContent());
        String filePath = this.getString(issue, "Path");
        String fileName = this.getString(issue, "File");
        String fileLine = this.getString(issue, "Line");
        Warning warning = this.createWarning(filePath + "/" + fileName, this.getLineNumber(fileLine), category, msgBuilder.toString(), this.getPriority(issueLevel));
        if (rule != null) {
            warning.setToolTip(rule.getDescription());
        }
        this.warnings.add((FileAnnotation)warning);
    }

    private String getString(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return "";
    }

    private Priority getPriority(String issueLevel) {
        if (issueLevel.contains("CriticalError")) {
            return Priority.HIGH;
        }
        if (issueLevel.contains("Error")) {
            return Priority.HIGH;
        }
        if (issueLevel.contains("CriticalWarning")) {
            return Priority.HIGH;
        }
        if (issueLevel.contains("Warning")) {
            return Priority.NORMAL;
        }
        return Priority.LOW;
    }
}

