/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser.gendarme;

import hudson.Extension;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.violations.types.fxcop.XmlElementUtil;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.plugins.warnings.parser.gendarme.GendarmeRule;
import hudson.plugins.warnings.parser.gendarme.GendarmeRuleType;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Extension
public class GendarmeParser
extends AbstractWarningsParser {
    private static final long serialVersionUID = 1677715364464119907L;
    private static final Pattern FILE_PATTERN = Pattern.compile("^(.*)\\(.(\\d+)\\).*$");

    public GendarmeParser() {
        super(Messages._Warnings_Gendarme_ParserName(), Messages._Warnings_Gendarme_LinkName(), Messages._Warnings_Gendarme_TrendName());
    }

    @Override
    public Collection<FileAnnotation> parse(Reader reader) throws IOException, ParsingCanceledException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(reader));
            NodeList mainNode = doc.getElementsByTagName("gendarme-output");
            Element rootElement = (Element)mainNode.item(0);
            Element resultsElement = (Element)rootElement.getElementsByTagName("results").item(0);
            Element rulesElement = (Element)rootElement.getElementsByTagName("rules").item(0);
            Map<String, GendarmeRule> rules = this.parseRules(XmlElementUtil.getNamedChildElements((Element)rulesElement, (String)"rule"));
            return this.parseViolations(XmlElementUtil.getNamedChildElements((Element)resultsElement, (String)"rule"), rules);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce);
        }
        catch (SAXException se) {
            throw new IOException(se);
        }
    }

    private List<FileAnnotation> parseViolations(List<Element> ruleElements, Map<String, GendarmeRule> rules) {
        ArrayList<FileAnnotation> warnings = new ArrayList<FileAnnotation>();
        for (Element ruleElement : ruleElements) {
            String ruleName = ruleElement.getAttribute("Name");
            String problem = ruleElement.getElementsByTagName("problem").item(0).getTextContent();
            List targetElements = XmlElementUtil.getNamedChildElements((Element)ruleElement, (String)"target");
            GendarmeRule rule = rules.get(ruleName);
            for (Element targetElement : targetElements) {
                Element defectElement = (Element)targetElement.getElementsByTagName("defect").item(0);
                String source = defectElement.getAttribute("Source");
                String fileName = this.extractFileNameMatch(rule, source, 1);
                Priority priority = this.extractPriority(defectElement);
                int line = GendarmeParser.convertLineNumber(this.extractFileNameMatch(rule, source, 2));
                warnings.add((FileAnnotation)this.createWarning(fileName, line, rule.getName(), problem, priority));
            }
        }
        return warnings;
    }

    private Priority extractPriority(Element defectElement) {
        String severityString = defectElement.getAttribute("Severity");
        Priority priority = "Low".equals(severityString) ? Priority.LOW : ("High".equals(severityString) ? Priority.HIGH : Priority.NORMAL);
        return priority;
    }

    private String extractFileNameMatch(GendarmeRule rule, String source, int group) {
        Matcher matcher;
        String fileName = "";
        if (rule.getType() == GendarmeRuleType.Method && (matcher = FILE_PATTERN.matcher(source)).matches()) {
            fileName = matcher.group(group);
        }
        return fileName;
    }

    private Map<String, GendarmeRule> parseRules(List<Element> ruleElements) {
        HashMap<String, GendarmeRule> rules = new HashMap<String, GendarmeRule>();
        for (Element ruleElement : ruleElements) {
            GendarmeRule rule = new GendarmeRule();
            rule.setName(ruleElement.getAttribute("Name"));
            rule.setTypeName(ruleElement.getTextContent());
            String typeString = ruleElement.getAttribute("Type");
            if ("Type".equals(typeString)) {
                rule.setType(GendarmeRuleType.Type);
            } else if ("Method".equals(typeString)) {
                rule.setType(GendarmeRuleType.Method);
            } else if ("Assembly".equals(typeString)) {
                rule.setType(GendarmeRuleType.Assembly);
            }
            try {
                rule.setUrl(new URL(ruleElement.getAttribute("Uri")));
            }
            catch (MalformedURLException e) {
                rule.setUrl(null);
            }
            rules.put(rule.getName(), rule);
        }
        return rules;
    }
}

