/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser.jcreport;

import hudson.Extension;
import hudson.plugins.analysis.util.SecureDigester;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.plugins.warnings.parser.Warning;
import hudson.plugins.warnings.parser.jcreport.File;
import hudson.plugins.warnings.parser.jcreport.Item;
import hudson.plugins.warnings.parser.jcreport.Report;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Extension
public class JcReportParser
extends AbstractWarningsParser {
    private static final long serialVersionUID = -1302787609831475403L;

    public JcReportParser() {
        super(Messages._Warnings_JCReport_ParserName(), Messages._Warnings_JCReport_LinkName(), Messages._Warnings_JCReport_TrendName());
    }

    @Override
    public Collection<FileAnnotation> parse(Reader reader) throws IOException, ParsingCanceledException {
        Report report = this.createReport(reader);
        ArrayList<FileAnnotation> warnings = new ArrayList<FileAnnotation>();
        for (int i = 0; i < report.getFiles().size(); ++i) {
            File file = report.getFiles().get(i);
            for (int j = 0; j < file.getItems().size(); ++j) {
                Item item = file.getItems().get(j);
                Warning warning = this.createWarning(file.getName(), this.getLineNumber(item.getLine()), item.getFindingtype(), item.getMessage(), this.getPriority(item.getSeverity()));
                warning.setOrigin(item.getOrigin());
                warning.setPackageName(file.getPackageName());
                warning.setPathName(file.getSrcdir());
                warning.setColumnPosition(this.getLineNumber(item.getColumn()), this.getLineNumber(item.getEndcolumn()));
                warnings.add((FileAnnotation)warning);
            }
        }
        return warnings;
    }

    private Priority getPriority(String issueLevel) {
        if (StringUtils.isEmpty((String)issueLevel)) {
            return Priority.HIGH;
        }
        if (issueLevel.contains("CriticalError")) {
            return Priority.HIGH;
        }
        if (issueLevel.contains("Error")) {
            return Priority.HIGH;
        }
        if (issueLevel.contains("CriticalWarning")) {
            return Priority.HIGH;
        }
        if (issueLevel.contains("Warning")) {
            return Priority.NORMAL;
        }
        return Priority.LOW;
    }

    public Report createReport(Reader source) throws IOException {
        try {
            SecureDigester digester = new SecureDigester(JcReportParser.class);
            String report = "report";
            digester.addObjectCreate(report, Report.class);
            digester.addSetProperties(report);
            String file = "report/file";
            digester.addObjectCreate(file, File.class);
            digester.addSetProperties(file, "package", "packageName");
            digester.addSetProperties(file, "src-dir", "srcdir");
            digester.addSetProperties(file);
            digester.addSetNext(file, "addFile", File.class.getName());
            String item = "report/file/item";
            digester.addObjectCreate(item, Item.class);
            digester.addSetProperties(item);
            digester.addSetProperties(item, "finding-type", "findingtype");
            digester.addSetProperties(item, "end-line", "endline");
            digester.addSetProperties(item, "end-column", "endcolumn");
            digester.addSetNext(item, "addItem", Item.class.getName());
            return (Report)digester.parse(new InputSource(source));
        }
        catch (SAXException exception) {
            throw new IOException(exception);
        }
    }
}

