/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.tokens;

import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.tokens.AbstractTokenMacro;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;

public abstract class AbstractDetailedTokenMacro
extends AbstractTokenMacro {
    private final List<String> modules = new ArrayList<String>();
    private boolean verbose;
    private boolean showLow = true;
    private boolean showNormal = true;
    private boolean showHigh = true;
    private String linechar = "-";
    private int indent;

    public AbstractDetailedTokenMacro(String tokenName, Class<? extends ResultAction<? extends BuildResult>> ... resultActions) {
        super(tokenName, (Class[])resultActions);
    }

    @DataBoundTokenMacro.Parameter(alias="indent")
    public void setIndent(int indentation) {
        this.indent = indentation;
    }

    @DataBoundTokenMacro.Parameter(alias="modules")
    public void setModules(String module) {
        this.modules.add(module);
    }

    @DataBoundTokenMacro.Parameter(alias="verbose")
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    @DataBoundTokenMacro.Parameter(alias="low")
    public void setLow(boolean show) {
        this.showLow = show;
    }

    @DataBoundTokenMacro.Parameter(alias="normal")
    public void setNormal(boolean show) {
        this.showNormal = show;
    }

    @DataBoundTokenMacro.Parameter(alias="high")
    public void setHigh(boolean show) {
        this.showHigh = show;
    }

    @DataBoundTokenMacro.Parameter(alias="linechar")
    public void setLineChar(String c) {
        this.linechar = c.substring(0, 1);
    }

    protected String evalWarnings(BuildResult result, Collection<FileAnnotation> warnings) {
        StringBuilder message = new StringBuilder();
        if (this.modules.isEmpty()) {
            this.modules.add("all");
        }
        for (String module : this.modules) {
            boolean allWarn = "all".equals(module);
            String heading = module + " annotations:";
            String tmp = "";
            for (FileAnnotation annotation : warnings) {
                Priority prio = annotation.getPriority();
                if (prio == Priority.LOW && !this.showLow || prio == Priority.NORMAL && !this.showNormal || prio == Priority.HIGH && !this.showHigh || !allWarn && !annotation.getType().equals(module)) continue;
                if (allWarn && this.verbose) {
                    tmp = tmp + annotation.getType() + ": ";
                }
                tmp = tmp + this.createMessage(annotation);
            }
            if (tmp.length() <= 0) continue;
            String ind = this.indent > 0 ? StringUtils.repeat((String)" ", (int)this.indent) : "";
            message.append(ind);
            message.append(heading);
            message.append("\n");
            message.append(ind);
            message.append(StringUtils.repeat((String)this.linechar, (int)heading.length()));
            message.append("\n");
            message.append(tmp);
            message.append("\n");
        }
        return message.toString();
    }

    private String createMessage(FileAnnotation annotation) {
        String ind = this.indent > 0 ? StringUtils.repeat((String)" ", (int)this.indent) : "";
        StringBuilder message = new StringBuilder();
        message.append(ind);
        if (annotation.getPrimaryLineNumber() > 0) {
            message.append(annotation.getFileName().replaceAll("^.*workspace/", ""));
            message.append(":");
            message.append(annotation.getPrimaryLineNumber());
            message.append(" ");
        }
        message.append(annotation.getMessage().replace("<br>", "\n" + ind));
        message.append("\n");
        String toolTip = annotation.getToolTip().replace("<br>", "\n");
        if (toolTip != null) {
            toolTip = ind + toolTip.replace("\n", "\n" + ind).trim();
            message.append(toolTip);
            message.append("\n");
        }
        return message.toString();
    }
}

