/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import hudson.FilePath;
import hudson.Util;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;
import jenkins.plugins.publish_over.Messages;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BPBuildEnv
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(BPBuildEnv.class);
    public static final String ENV_NODE_NAME = "NODE_NAME";
    public static final String ENV_JOB_NAME = "JOB_NAME";
    public static final String ENV_BUILD_NUMBER = "BUILD_NUMBER";
    private TreeMap<String, String> envVars;
    private FilePath baseDirectory;
    private Calendar buildTime;

    public BPBuildEnv() {
    }

    public BPBuildEnv(TreeMap<String, String> envVars, FilePath baseDirectory, Calendar buildTime) {
        this.envVars = envVars;
        this.baseDirectory = baseDirectory;
        this.buildTime = buildTime;
    }

    public TreeMap<String, String> getEnvVars() {
        return this.envVars;
    }

    public void setEnvVars(TreeMap<String, String> envVars) {
        this.envVars = envVars;
    }

    public FilePath getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(FilePath baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public Calendar getBuildTime() {
        return this.buildTime;
    }

    public void setBuildTime(Calendar buildTime) {
        this.buildTime = buildTime;
    }

    public TreeMap<String, String> getEnvVarsWithPrefix(String prefix) {
        TreeMap<String, String> prefixed = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
            prefixed.put(prefix + entry.getKey(), entry.getValue());
        }
        return prefixed;
    }

    public void logEnvVars() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.log_envVars_head());
            StringBuilder builder = new StringBuilder("\n");
            for (Map.Entry<String, String> var : this.envVars.entrySet()) {
                builder.append(Messages.log_envVars_pair(var.getKey(), var.getValue()));
                builder.append("\n");
            }
            LOG.debug((Object)builder.toString());
        }
    }

    public void fixMasterNodeName(String masterNodeName) {
        this.fixEmptyButNotMissingEnvVar(ENV_NODE_NAME, masterNodeName);
    }

    private void fixEmptyButNotMissingEnvVar(String envVarName, String replacement) {
        if (Util.fixEmptyAndTrim((String)replacement) == null) {
            return;
        }
        if (!this.envVars.containsKey(envVarName)) {
            return;
        }
        if (Util.fixEmptyAndTrim((String)this.envVars.get(envVarName)) == null) {
            this.envVars.put(envVarName, replacement);
        }
    }

    public String getNormalizedBaseDirectory() {
        try {
            return this.baseDirectory.toURI().normalize().getPath();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.exception_normalizeDirectory(this.baseDirectory), e);
        }
    }

    private String safeGetNormalizedBaseDirectory() {
        if (this.baseDirectory == null) {
            return null;
        }
        try {
            return this.getNormalizedBaseDirectory();
        }
        catch (RuntimeException re) {
            return re.getLocalizedMessage();
        }
    }

    private String safeGetBuildTime() {
        if (this.buildTime == null) {
            return null;
        }
        try {
            return DateFormat.getDateTimeInstance().format(this.buildTime.getTime());
        }
        catch (RuntimeException re) {
            return re.getLocalizedMessage();
        }
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        if (this.envVars != null) {
            builder.append(ENV_JOB_NAME, (Object)this.envVars.get(ENV_JOB_NAME)).append(ENV_BUILD_NUMBER, (Object)this.envVars.get(ENV_BUILD_NUMBER));
        }
        return builder.append("baseDirectory", (Object)this.safeGetNormalizedBaseDirectory()).append("buildTime", (Object)this.safeGetBuildTime());
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }
}

