/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPHostConfiguration;
import jenkins.plugins.publish_over.BapPublisher;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over.Messages;

public class BPCallablePublisher
extends MasterToSlaveFileCallable<Void> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BPCallablePublisher.class.getName());
    private BapPublisher publisher;
    private BPHostConfiguration hostConfig;
    private BPBuildInfo buildInfo;

    public BPCallablePublisher() {
    }

    public BPCallablePublisher(BapPublisher publisher, BPHostConfiguration hostConfig, BPBuildInfo buildInfo) {
        this.publisher = publisher;
        this.hostConfig = hostConfig;
        this.buildInfo = buildInfo;
    }

    public BapPublisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(BapPublisher publisher) {
        this.publisher = publisher;
    }

    public BPBuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void setBuildInfo(BPBuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    public Void invoke(File file, VirtualChannel channel) throws IOException {
        try {
            this.printHostName();
            this.publisher.perform(this.hostConfig, this.buildInfo);
        }
        catch (Exception e) {
            String message = Messages.exception_remoteCallException(e.getLocalizedMessage());
            LOGGER.log(Level.WARNING, message, e);
            throw new BapPublisherException(message, e);
        }
        return null;
    }

    private void printHostName() {
        try {
            this.buildInfo.println(Messages.console_publishFromHost_message(InetAddress.getLocalHost().getHostName()));
        }
        catch (UnknownHostException uhe) {
            LOGGER.log(Level.WARNING, Messages.exception_failedToGetHostName(), uhe);
            this.buildInfo.println(Messages.console_publishFromHost_unknown(uhe.getLocalizedMessage()));
        }
    }
}

