/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.TreeMap;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.BPBuildEnv;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPClient;
import jenkins.plugins.publish_over.BPHostConfigurationAccess;
import jenkins.plugins.publish_over.BPInstanceConfig;
import jenkins.plugins.publish_over.BapPublisher;
import jenkins.plugins.publish_over.Messages;
import jenkins.plugins.publish_over.ParamPublish;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class BPPlugin<PUBLISHER extends BapPublisher, CLIENT extends BPClient, COMMON_CONFIG>
extends Notifier
implements SimpleBuildStep,
BPHostConfigurationAccess<CLIENT, COMMON_CONFIG> {
    public static final String PROMOTION_JOB_TYPE = "hudson.plugins.promoted_builds.PromotionProcess";
    public static final String PROMOTION_CLASS_NAME = "hudson.plugins.promoted_builds.Promotion";
    private final String consolePrefix;
    private BPInstanceConfig delegate;

    public BPPlugin(String consolePrefix) {
        this(consolePrefix, new BPInstanceConfig());
    }

    public BPPlugin(String consolePrefix, ArrayList<PUBLISHER> publishers, boolean continueOnError, boolean failOnError, boolean alwaysPublishFromMaster, String masterNodeName, ParamPublish paramPublish) {
        this(consolePrefix, new BPInstanceConfig<PUBLISHER>(publishers, continueOnError, failOnError, alwaysPublishFromMaster, masterNodeName, paramPublish));
    }

    private BPPlugin(String consolePrefix, BPInstanceConfig delegate) {
        this.delegate = delegate;
        this.delegate.setHostConfigurationAccess(this);
        this.consolePrefix = consolePrefix;
    }

    public BPInstanceConfig getInstanceConfig() {
        return this.delegate;
    }

    public BPInstanceConfig getDelegate() {
        return this.delegate;
    }

    public void setDelegate(BPInstanceConfig delegate) {
        this.delegate = delegate;
        delegate.setHostConfigurationAccess(this);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private TreeMap<String, String> getEnvironmentVariables(Run<?, ?> build, TaskListener listener) {
        try {
            EnvVars env = build.getEnvironment(listener);
            if (build instanceof AbstractBuild) {
                env.putAll(((AbstractBuild)build).getBuildVariables());
            }
            return env;
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.exception_failedToGetEnvVars(), e);
        }
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Jenkins jenkins;
        PrintStream console = listener.getLogger();
        if (!this.isBuildGoodEnoughToRun(build, console)) {
            return;
        }
        BPBuildEnv currentBuildEnv = new BPBuildEnv(this.getEnvironmentVariables(build, listener), workspace, build.getTimestamp());
        BPBuildEnv targetBuildEnv = null;
        if (PROMOTION_CLASS_NAME.equals(build.getClass().getCanonicalName())) {
            AbstractBuild promoted;
            try {
                Method getTarget = build.getClass().getMethod("getTarget", null);
                promoted = (AbstractBuild)getTarget.invoke(build, (Object[])null);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.exception_failedToGetPromotedBuild(), e);
            }
            targetBuildEnv = new BPBuildEnv(this.getEnvironmentVariables((Run<?, ?>)promoted, listener), new FilePath(promoted.getArtifactsDir()), promoted.getTimestamp());
        }
        if ((jenkins = Jenkins.getInstance()) == null) {
            return;
        }
        BPBuildInfo buildInfo = new BPBuildInfo(listener, this.consolePrefix, jenkins.getRootPath(), currentBuildEnv, targetBuildEnv);
        this.fixup(build, buildInfo);
        Result result = this.delegate.perform(buildInfo);
        Result buildRes = build.getResult();
        if (buildRes == null) {
            build.setResult(result);
        } else {
            build.setResult(result.combine(buildRes));
        }
    }

    protected void fixup(Run<?, ?> build, BPBuildInfo buildInfo) {
    }

    protected boolean isBuildGoodEnoughToRun(Run<?, ?> build, PrintStream console) {
        if (build == null) {
            return false;
        }
        Result result = build.getResult();
        if (result != null && !result.isBetterOrEqualTo(Result.UNSTABLE)) {
            console.println(this.consolePrefix + Messages.console_notPerforming(build.getResult()));
            return false;
        }
        return true;
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return builder.append((Object)this.delegate).append((Object)this.consolePrefix);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, BPPlugin that) {
        return builder.append((Object)this.delegate, (Object)that.delegate).append((Object)this.consolePrefix, (Object)that.consolePrefix);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return builder.append("consolePrefix", (Object)this.consolePrefix).append("delegate", (Object)this.delegate);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (BPPlugin)that).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }
}

