/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import hudson.FilePath;
import hudson.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPClient;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over.BapTransferException;
import jenkins.plugins.publish_over.FileFinder;
import jenkins.plugins.publish_over.FileFinderResult;
import jenkins.plugins.publish_over.Messages;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BPTransfer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(BPTransfer.class);
    private final String remoteDirectory;
    private final String sourceFiles;
    private final String excludes;
    private final String removePrefix;
    private final boolean remoteDirectorySDF;
    private final boolean flatten;
    private final boolean cleanRemote;
    private final boolean noDefaultExcludes;
    private final boolean makeEmptyDirs;
    private final String patternSeparator;

    private static FileFinderResult list(FilePath base, String includes, String excludes, boolean noDefaultExcludes, boolean makeEmptyDirs, String patternSeparator) {
        try {
            return (FileFinderResult)base.act((FilePath.FileCallable)new FileFinder(includes, excludes, !noDefaultExcludes, makeEmptyDirs, patternSeparator));
        }
        catch (IOException ioe) {
            throw new BapPublisherException(Messages.exception_invokeListNoDefaultExcludes(includes, excludes, noDefaultExcludes), ioe);
        }
        catch (InterruptedException ie) {
            throw new BapPublisherException(Messages.exception_invokeListNoDefaultExcludes(includes, excludes, noDefaultExcludes), ie);
        }
    }

    BPTransfer(String sourceFiles, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean flatten) {
        this(sourceFiles, null, remoteDirectory, removePrefix, remoteDirectorySDF, flatten, false, false, false, null);
    }

    public BPTransfer(String sourceFiles, String excludes, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean flatten) {
        this(sourceFiles, excludes, remoteDirectory, removePrefix, remoteDirectorySDF, flatten, false, false, false, null);
    }

    public BPTransfer(String sourceFiles, String excludes, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean flatten, boolean cleanRemote, boolean noDefaultExcludes, boolean makeEmptyDirs, String patternSeparator) {
        this.sourceFiles = sourceFiles;
        this.excludes = excludes;
        this.remoteDirectory = remoteDirectory;
        this.removePrefix = removePrefix;
        this.remoteDirectorySDF = remoteDirectorySDF;
        this.flatten = flatten;
        this.cleanRemote = cleanRemote;
        this.noDefaultExcludes = noDefaultExcludes;
        this.makeEmptyDirs = makeEmptyDirs;
        this.patternSeparator = patternSeparator;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public String getSourceFiles() {
        return this.sourceFiles;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getRemovePrefix() {
        return this.removePrefix;
    }

    public boolean isRemoteDirectorySDF() {
        return this.remoteDirectorySDF;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public boolean isCleanRemote() {
        return this.cleanRemote;
    }

    public boolean isNoDefaultExcludes() {
        return this.noDefaultExcludes;
    }

    public boolean isMakeEmptyDirs() {
        return this.makeEmptyDirs;
    }

    public String getPatternSeparator() {
        return this.patternSeparator;
    }

    public boolean hasConfiguredSourceFiles() {
        return Util.fixEmptyAndTrim((String)this.getSourceFiles()) != null;
    }

    public FileFinderResult getSourceFiles(BPBuildInfo buildInfo) throws IOException, InterruptedException {
        String expanded = Util.replaceMacro((String)this.sourceFiles, buildInfo.getEnvVars());
        String expandedExcludes = Util.fixEmptyAndTrim((String)Util.replaceMacro((String)this.excludes, buildInfo.getEnvVars()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.log_sourceFiles(this.sourceFiles, expanded));
            if (expandedExcludes != null) {
                LOG.debug((Object)Messages.log_excludes(this.excludes, expandedExcludes));
            }
        }
        return BPTransfer.list(buildInfo.getBaseDirectory(), expanded, expandedExcludes, this.noDefaultExcludes, this.makeEmptyDirs, this.patternSeparator);
    }

    private void assertBaseDirectoryExists(BPBuildInfo buildInfo) throws Exception {
        if (!buildInfo.getBaseDirectory().exists()) {
            throw new BapPublisherException(Messages.exception_baseDirectoryNotExist());
        }
    }

    public int transfer(BPBuildInfo buildInfo, BPClient client) throws Exception {
        this.assertBaseDirectoryExists(buildInfo);
        return this.transfer(buildInfo, client, TransferState.create(this.getSourceFiles(buildInfo)));
    }

    public int transfer(BPBuildInfo buildInfo, BPClient client, TransferState state) {
        try {
            DirectoryMaker dirMaker = new DirectoryMaker(buildInfo, client);
            if (this.cleanRemote && !state.doneCleaning) {
                dirMaker.resetToSubDirectory();
                client.deleteTree();
                state.doneCleaning = true;
            }
            while (state.transferred < state.sourceFiles.length) {
                dirMaker.changeAndMakeDirs(state.sourceFiles[state.transferred], false);
                this.transferFile(client, state.sourceFiles[state.transferred]);
                state.transferred++;
            }
            while (state.dirsMade < state.emptyDirs.length) {
                dirMaker.changeAndMakeDirs(state.emptyDirs[state.dirsMade], true);
                state.dirsMade++;
            }
        }
        catch (Exception e) {
            throw new BapTransferException(e, state);
        }
        return state.transferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferFile(BPClient client, FilePath filePath) throws Exception {
        try (InputStream inputStream = filePath.read();){
            client.transferFile(this, filePath, inputStream);
        }
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return builder.append((Object)this.sourceFiles).append((Object)this.removePrefix).append((Object)this.remoteDirectory).append(this.remoteDirectorySDF).append(this.flatten).append(this.cleanRemote).append((Object)this.excludes).append(this.noDefaultExcludes).append(this.makeEmptyDirs).append((Object)this.patternSeparator);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, BPTransfer that) {
        return builder.append((Object)this.sourceFiles, (Object)that.sourceFiles).append((Object)this.removePrefix, (Object)that.removePrefix).append((Object)this.excludes, (Object)that.excludes).append((Object)this.remoteDirectory, (Object)that.remoteDirectory).append(this.remoteDirectorySDF, that.remoteDirectorySDF).append(this.flatten, that.flatten).append(this.cleanRemote, that.cleanRemote).append(this.noDefaultExcludes, that.noDefaultExcludes).append(this.makeEmptyDirs, that.makeEmptyDirs).append((Object)this.patternSeparator, (Object)that.patternSeparator);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return builder.append("sourceFiles", (Object)this.sourceFiles).append("excludes", (Object)this.excludes).append("removePrefix", (Object)this.removePrefix).append("remoteDirectory", (Object)this.remoteDirectory).append("remoteDirectorySDF", this.remoteDirectorySDF).append("flatten", this.flatten).append("cleanRemote", this.cleanRemote).append("noDefaultExcludes", this.noDefaultExcludes).append("makeEmptyDirs", this.makeEmptyDirs).append("patternSeparator", (Object)this.patternSeparator);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (BPTransfer)that).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    public static final class TransferState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final FilePath[] sourceFiles;
        private final FilePath[] emptyDirs;
        private int transferred;
        private int dirsMade;
        private boolean doneCleaning;

        private TransferState(FileFinderResult sources) {
            this.sourceFiles = sources.getFiles();
            this.emptyDirs = sources.getDirectories();
        }

        protected static TransferState create(FileFinderResult sources) {
            return new TransferState(sources);
        }
    }

    private class DirectoryMaker {
        private final BPBuildInfo buildInfo;
        private final BPClient client;
        private final Set<String> flattenedFileNames = new LinkedHashSet<String>();
        private boolean flattenResetCompleted;
        private String previousPath;
        private String relativeRemoteSubDirectory;

        DirectoryMaker(BPBuildInfo buildInfo, BPClient client) throws IOException {
            this.buildInfo = buildInfo;
            this.client = client;
        }

        public void changeAndMakeDirs(FilePath filePath, boolean isDirectory) throws IOException, InterruptedException {
            String relPath;
            if (BPTransfer.this.flatten) {
                this.assertNotDuplicateFileName(filePath);
                if (!this.flattenResetCompleted) {
                    this.resetToSubDirectory();
                    this.flattenResetCompleted = true;
                }
            }
            String string = relPath = isDirectory ? this.buildInfo.getRelativeDir(filePath, BPTransfer.this.removePrefix) : this.buildInfo.getRelativePathToFile(filePath, BPTransfer.this.removePrefix);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.log_pathToFile(filePath.getName(), relPath));
            }
            if (!relPath.equals(this.previousPath) && !BPTransfer.this.flatten) {
                this.resetToSubDirectory();
                this.changeToTargetDirectory(filePath);
                this.previousPath = relPath;
            }
        }

        private void assertNotDuplicateFileName(FilePath filePath) {
            String fileName = filePath.getName();
            if (this.flattenedFileNames.contains(fileName)) {
                throw new BapPublisherException(Messages.exception_flattenModeDuplicateFileName(fileName));
            }
            this.flattenedFileNames.add(fileName);
        }

        private void changeToSubDirectory() throws IOException {
            if (this.relativeRemoteSubDirectory == null) {
                this.relativeRemoteSubDirectory = this.getRelativeRemoteDirectory();
            }
            if (!"".equals(this.relativeRemoteSubDirectory)) {
                this.chdir(this.relativeRemoteSubDirectory);
            }
        }

        private String getRelativeRemoteDirectory() {
            String relative = BPTransfer.this.remoteDirectory;
            if (relative == null) {
                return "";
            }
            relative = Util.replaceMacro((String)relative, this.buildInfo.getEnvVars());
            if ((relative = FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)relative))) == null) {
                return "";
            }
            if (BPTransfer.this.remoteDirectorySDF) {
                relative = this.buildTimeFormat(relative);
            }
            if ((relative = Util.fixEmptyAndTrim((String)relative)) == null) {
                return "";
            }
            if (relative.charAt(0) == '/') {
                return relative.substring(1);
            }
            return relative;
        }

        private String buildTimeFormat(String simpleDateFormatString) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(simpleDateFormatString, Locale.getDefault());
                return sdf.format(this.buildInfo.getBuildTime().getTime());
            }
            catch (IllegalArgumentException iae) {
                throw new BapPublisherException(Messages.exception_badDateFormat(simpleDateFormatString, iae.getLocalizedMessage()), iae);
            }
        }

        private String[] getDirectories(String directoryPath) {
            if (directoryPath.contains("/")) {
                return directoryPath.split("/");
            }
            if (directoryPath.contains("\\")) {
                return directoryPath.split("\\\\");
            }
            return new String[]{directoryPath};
        }

        private void chdir(String directory) throws IOException {
            if (!this.changeOrMakeAndChangeDirectory(directory)) {
                for (String dir : this.getDirectories(directory)) {
                    if (this.changeOrMakeAndChangeDirectory(dir)) continue;
                    throw new BapPublisherException(Messages.exception_failedToCreateDirectory(dir));
                }
            }
        }

        private boolean changeOrMakeAndChangeDirectory(String directory) throws IOException {
            if (this.client.changeDirectory(directory)) {
                return true;
            }
            return this.client.makeDirectory(directory) && this.client.changeDirectory(directory);
        }

        private void changeToTargetDirectory(FilePath filePath) throws IOException, InterruptedException {
            if (BPTransfer.this.flatten) {
                return;
            }
            String relativePath = this.buildInfo.getRelativePathToFile(filePath, BPTransfer.this.removePrefix);
            if (!"".equals(relativePath)) {
                this.chdir(relativePath);
            }
        }

        private void resetToSubDirectory() throws IOException {
            this.client.changeToInitialDirectory();
            this.changeToSubDirectory();
        }
    }
}

