/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import hudson.Util;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.JenkinsCapabilities;
import jenkins.plugins.publish_over.Messages;

public class BPValidators {
    private static final String VALID_NAME_ILLEGAL_CHARS = "< & ' \" \\";
    private static final Pattern FOUR_NUMBERS_DOT_DELIM = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final int OCTETS_IN_IPV4 = 4;
    private static final int OCTET_MAX_VALUE = 255;

    public static String getIllegalCharacters() {
        return VALID_NAME_ILLEGAL_CHARS;
    }

    public static boolean isValidName(String proposed) {
        return Util.fixEmptyAndTrim((String)proposed) != null && proposed.matches("[^<&'\"\\\\]+");
    }

    public static FormValidation validateName(String name) {
        return BPValidators.isValidName(name) ? FormValidation.ok() : FormValidation.error((String)Messages.validator_safeName(VALID_NAME_ILLEGAL_CHARS));
    }

    public static FormValidation validateOptionalIp(String ipAddress) {
        if (Util.fixEmptyAndTrim((String)ipAddress) == null) {
            return FormValidation.ok();
        }
        Matcher matcher = FOUR_NUMBERS_DOT_DELIM.matcher(ipAddress.trim());
        if (!matcher.matches()) {
            return FormValidation.error((String)Messages.validator_optionalIP());
        }
        for (int octet = 1; octet < 5; ++octet) {
            if (BPValidators.isOctetValid(matcher.group(octet))) continue;
            return FormValidation.error((String)Messages.validator_optionalIP());
        }
        return FormValidation.ok();
    }

    private static boolean isOctetValid(String octetString) {
        int octet = Integer.parseInt(octetString);
        return octet < 256;
    }

    public static FormValidation validateFileOnMaster(String value) {
        if (JenkinsCapabilities.missing(JenkinsCapabilities.VALIDATE_FILE_ON_MASTER_FROM_GLOBAL_CFG)) {
            return FormValidation.ok();
        }
        try {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return FormValidation.error((String)"Unable to access Jenkins instance");
            }
            return jenkins.getRootPath().validateRelativePath(value, true, true);
        }
        catch (IOException ioe) {
            return FormValidation.error((Throwable)ioe, (String)"");
        }
    }

    public static FormValidation validateRegularExpression(String value) {
        try {
            Pattern.compile(value);
            return FormValidation.ok();
        }
        catch (PatternSyntaxException pse) {
            return FormValidation.error((Throwable)pse, (String)Messages.validator_regularExpression(pse.getLocalizedMessage()));
        }
    }
}

