/*
 * Decompiled with CFR 0.152.
 */
package de.java2html;

import de.java2html.Java2Html;
import de.java2html.Version;
import de.java2html.gui.DirectTextConversionPanel;
import de.java2html.gui.FileConversionPanel;
import de.java2html.gui.GuiTools;
import de.java2html.gui.IStatisticsView;
import de.java2html.gui.Java2HtmlOptionsPanel;
import de.java2html.javasource.JavaSourceStatistic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class Java2HtmlApplication {
    private final JFrame frame;
    private final JButton bExit;
    private final Java2HtmlOptionsPanel optionsPanel = new Java2HtmlOptionsPanel();

    public Java2HtmlApplication() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("File Conversion", new FileConversionPanel(this.optionsPanel).getContent());
        tabbedPane.addTab("Direct Text Conversion", new DirectTextConversionPanel(this.optionsPanel, new IStatisticsView(){

            public void setStatistics(JavaSourceStatistic statistic) {
            }
        }).getContent());
        this.bExit = new JButton("Exit");
        this.bExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        JPanel southPanel = new JPanel(new FlowLayout(2));
        southPanel.add(this.bExit);
        JPanel pOptions = GuiTools.createBorderedPanel("Options");
        pOptions.setLayout(new BorderLayout());
        pOptions.add((Component)this.optionsPanel.getContent(), "Center");
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)pOptions, "North");
        p.add(Box.createVerticalGlue(), "Center");
        this.frame = new JFrame(Version.getJava2HtmlConverterTitle());
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout(4, 4));
        this.frame.getContentPane().add((Component)p, "East");
        this.frame.getContentPane().add((Component)tabbedPane, "Center");
        this.frame.getContentPane().add((Component)southPanel, "South");
    }

    private void show() {
        this.frame.pack();
        GuiTools.centerOnScreen(this.frame);
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            Java2Html.main(args);
            return;
        }
        GuiTools.setNativeLookAndFeel();
        Java2HtmlApplication application = new Java2HtmlApplication();
        application.show();
    }
}

