/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.commandline.test;

import de.java2html.commandline.IJava2HtmlConversion;
import de.java2html.commandline.IllegalCommandlineParametersException;
import de.java2html.commandline.Java2HtmlCommandline;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.test.BasicTestCase;

public class Java2HtmlCommandlineTest
extends BasicTestCase {
    static /* synthetic */ Class class$de$java2html$commandline$Java2HtmlDirectoryConversion;
    static /* synthetic */ Class class$de$java2html$commandline$Java2HtmlFileConversion;
    static /* synthetic */ Class class$de$java2html$converter$JavaSource2HTMLConverter;
    static /* synthetic */ Class class$de$java2html$converter$JavaSource2TeXConverter;
    static /* synthetic */ Class class$de$java2html$commandline$IllegalCommandlineParametersException;

    public void testCreateDirectoryConverter() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcdir", "d:/src"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Java2HtmlCommandlineTest.assertInstanceOf(class$de$java2html$commandline$Java2HtmlDirectoryConversion == null ? (class$de$java2html$commandline$Java2HtmlDirectoryConversion = Java2HtmlCommandlineTest.class$("de.java2html.commandline.Java2HtmlDirectoryConversion")) : class$de$java2html$commandline$Java2HtmlDirectoryConversion, conversion);
    }

    public void testCreateFileConverter() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Java2HtmlCommandlineTest.assertInstanceOf(class$de$java2html$commandline$Java2HtmlFileConversion == null ? (class$de$java2html$commandline$Java2HtmlFileConversion = Java2HtmlCommandlineTest.class$("de.java2html.commandline.Java2HtmlFileConversion")) : class$de$java2html$commandline$Java2HtmlFileConversion, conversion);
    }

    public void testHtmlIsDefaultConverter() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Java2HtmlCommandlineTest.assertInstanceOf(class$de$java2html$converter$JavaSource2HTMLConverter == null ? (class$de$java2html$converter$JavaSource2HTMLConverter = Java2HtmlCommandlineTest.class$("de.java2html.converter.JavaSource2HTMLConverter")) : class$de$java2html$converter$JavaSource2HTMLConverter, conversion.getConverter());
    }

    public void testUsesSpecifiedConverter() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-converter", "TeX"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Java2HtmlCommandlineTest.assertInstanceOf(class$de$java2html$converter$JavaSource2TeXConverter == null ? (class$de$java2html$converter$JavaSource2TeXConverter = Java2HtmlCommandlineTest.class$("de.java2html.converter.JavaSource2TeXConverter")) : class$de$java2html$converter$JavaSource2TeXConverter, conversion.getConverter());
    }

    public void testUnknwonConverterThrowsException() {
        final String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-converter", "UnknownConverterName"};
        Java2HtmlCommandlineTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = Java2HtmlCommandlineTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                Java2HtmlCommandline.createCommandlineConversion(arguments);
            }
        });
    }

    public void testUsesCorrectDefaultStyle() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Java2HtmlCommandlineTest.assertEquals((Object)JavaSourceStyleTable.getDefault(), (Object)conversion.getConversionOptions().getStyleTable());
    }

    public void testUsesSpecifiedStyle() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-style", "Monochrome"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Java2HtmlCommandlineTest.assertEquals((Object)JavaSourceStyleTable.getPredefinedTable("Monochrome"), (Object)conversion.getConversionOptions().getStyleTable());
    }

    public void testUnknownStyleThrowsException() {
        final String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-style", "UnknownStyleName"};
        Java2HtmlCommandlineTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = Java2HtmlCommandlineTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                Java2HtmlCommandline.createCommandlineConversion(arguments);
            }
        });
    }

    public void testUsesDefaultTabs() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Java2HtmlCommandlineTest.assertEquals((int)JavaSourceConversionOptions.getDefault().getTabSize(), (int)conversion.getConversionOptions().getTabSize());
    }

    public void testUsesSpecifiedTabs() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-tabs", "5"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Java2HtmlCommandlineTest.assertEquals((int)5, (int)conversion.getConversionOptions().getTabSize());
    }

    public void testIllegalTabsThrowsException() {
        final String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-tabs", "illegal"};
        Java2HtmlCommandlineTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = Java2HtmlCommandlineTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                Java2HtmlCommandline.createCommandlineConversion(arguments);
            }
        });
    }

    public void testNegativeTabsThrowsException() {
        final String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-tabs", "-3"};
        Java2HtmlCommandlineTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = Java2HtmlCommandlineTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                Java2HtmlCommandline.createCommandlineConversion(arguments);
            }
        });
    }

    public void testUnsupportedArgumentThrowsException() {
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-anUnsupportedArgument"});
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-srcfile"});
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-srcfile", "d:/src/test.java", "-filemask", "*.txt"});
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-srcfile", "d:/src/test.java", "-copytotargetunprocessedfiles"});
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-srcdir", "d:/src", "-copytotargetunprocessedfiles", "true"});
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-srcdir", "d:/src", "-copytotargetunprocessedfiles", "-anything"});
    }

    private static void assertIsIllegalCommandLineArguments(final String[] arguments) {
        Java2HtmlCommandlineTest.assertThrowsException(class$de$java2html$commandline$IllegalCommandlineParametersException == null ? (class$de$java2html$commandline$IllegalCommandlineParametersException = Java2HtmlCommandlineTest.class$("de.java2html.commandline.IllegalCommandlineParametersException")) : class$de$java2html$commandline$IllegalCommandlineParametersException, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                Java2HtmlCommandline.createCommandlineConversion(arguments);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

