/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter;

import de.java2html.converter.AbstractJavaSourceToXmlConverter;
import de.java2html.converter.ConverterMetaData;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceType;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import java.io.BufferedWriter;
import java.io.IOException;

public class JavaSource2XmlConverter
extends AbstractJavaSourceToXmlConverter {
    private static final String BLOCK_LINE_NUMBERS = "lines>";
    private static final String BLOCK_STYLE = "style>";
    private static final String BLOCK_JAVA = "source>";
    private static final String BLOCK_ROOT = "java>";

    protected String createHeader(JavaSourceStyleTable styleTable, String title) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<java><style>" + JavaSource2XmlConverter.createStyleSheet(styleTable) + "</" + BLOCK_STYLE + "\n";
    }

    public JavaSource2XmlConverter() {
        super(new ConverterMetaData("xml", "XML", "xml"));
    }

    public String getName() {
        return "xml";
    }

    protected String getHeaderEnd() {
        return "";
    }

    protected String getFooter() {
        return "</java>";
    }

    public void convert(JavaSource source, JavaSourceConversionOptions options, BufferedWriter writer) throws IOException {
        if (source == null) {
            throw new IllegalStateException("Trying to write out converted code without having source set.");
        }
        String sourceCode = source.getCode();
        JavaSourceType[] sourceTypes = source.getClassification();
        if (this.lineNumbers) {
            writer.write("<lines>");
            for (int i = 1; i <= source.getLineCount(); ++i) {
                writer.write(String.valueOf(i) + this.lineEnd);
                writer.newLine();
            }
            writer.write("</lines>");
        }
        writer.write("<source>");
        int start = 0;
        int end = 0;
        while (start < sourceTypes.length) {
            while (end < sourceTypes.length - 1 && (sourceTypes[end + 1] == sourceTypes[start] || sourceTypes[end + 1] == JavaSourceType.BACKGROUND)) {
                ++end;
            }
            this.toXml(sourceCode, sourceTypes, start, end, writer);
            end = start = end + 1;
        }
        writer.write("</source>");
    }
}

