/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.javasource.test;

import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceIterator;
import de.java2html.javasource.JavaSourceRun;
import de.java2html.javasource.JavaSourceType;
import de.java2html.javasource.test.JavaSourceParserTestCase;
import java.io.IOException;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class JavaSourceIteratorTest
extends TestCase {
    public void testEmpty() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("");
        JavaSourceIterator iterator = source.getIterator();
        JavaSourceIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testFirstIsNewLine() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("\na");
        JavaSourceIterator iterator = source.getIterator();
        JavaSourceIteratorTest.assertTrue((boolean)iterator.hasNext());
        JavaSourceRun run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"", (String)run.getCode());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtStartOfLine());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtEndOfLine());
        JavaSourceIteratorTest.assertEquals((Object)JavaSourceType.BACKGROUND, (Object)run.getType());
        JavaSourceIteratorTest.assertTrue((boolean)iterator.hasNext());
        run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"a", (String)run.getCode());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtStartOfLine());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtEndOfLine());
        JavaSourceIteratorTest.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        JavaSourceIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testSingle() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("a");
        JavaSourceIterator iterator = source.getIterator();
        JavaSourceIteratorTest.assertTrue((boolean)iterator.hasNext());
        JavaSourceRun run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"a", (String)run.getCode());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtStartOfLine());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtEndOfLine());
        JavaSourceIteratorTest.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        JavaSourceIteratorTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            JavaSourceIteratorTest.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
    }

    public void testTwoLines() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("a\nb");
        JavaSourceIterator iterator = source.getIterator();
        JavaSourceRun run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"a", (String)run.getCode());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtStartOfLine());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtEndOfLine());
        JavaSourceIteratorTest.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        JavaSourceIteratorTest.assertTrue((boolean)iterator.hasNext());
        run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"b", (String)run.getCode());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtStartOfLine());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtEndOfLine());
        JavaSourceIteratorTest.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        JavaSourceIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void test1() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("public String text =\"test\";");
        JavaSourceIterator iterator = source.getIterator();
        JavaSourceIteratorTest.assertTrue((boolean)iterator.hasNext());
        JavaSourceRun run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"public ", (String)run.getCode());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtStartOfLine());
        JavaSourceIteratorTest.assertFalse((boolean)run.isAtEndOfLine());
        JavaSourceIteratorTest.assertEquals((Object)JavaSourceType.KEYWORD, (Object)run.getType());
        JavaSourceIteratorTest.assertTrue((boolean)iterator.hasNext());
        run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"String text =", (String)run.getCode());
        JavaSourceIteratorTest.assertFalse((boolean)run.isAtStartOfLine());
        JavaSourceIteratorTest.assertFalse((boolean)run.isAtEndOfLine());
        JavaSourceIteratorTest.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        JavaSourceIteratorTest.assertTrue((boolean)iterator.hasNext());
        run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"\"test\"", (String)run.getCode());
        JavaSourceIteratorTest.assertFalse((boolean)run.isAtStartOfLine());
        JavaSourceIteratorTest.assertFalse((boolean)run.isAtEndOfLine());
        JavaSourceIteratorTest.assertEquals((Object)JavaSourceType.STRING, (Object)run.getType());
        JavaSourceIteratorTest.assertTrue((boolean)iterator.hasNext());
        run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)";", (String)run.getCode());
        JavaSourceIteratorTest.assertFalse((boolean)run.isAtStartOfLine());
        JavaSourceIteratorTest.assertTrue((boolean)run.isAtEndOfLine());
        JavaSourceIteratorTest.assertEquals((Object)JavaSourceType.CODE, (Object)run.getType());
        JavaSourceIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testEmptyLinesAreEmptyRuns() throws IOException {
        JavaSource source = JavaSourceParserTestCase.doParse("public\n\ntest");
        JavaSourceIterator iterator = source.getIterator();
        JavaSourceRun run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"public", (String)run.getCode());
        run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"", (String)run.getCode());
        run = iterator.getNext();
        JavaSourceIteratorTest.assertEquals((String)"test", (String)run.getCode());
        JavaSourceIteratorTest.assertFalse((boolean)iterator.hasNext());
    }
}

