/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.options;

import de.java2html.options.HorizontalAlignment;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.properties.ConversionOptionsPropertiesReader;
import de.java2html.util.Ensure;
import de.java2html.util.IllegalConfigurationException;
import de.java2html.util.IoUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class JavaSourceConversionOptions {
    private static final String PROPERTIES_FILE_NAME = "java2html.properties";
    public static final String TAB_SIZE = "TAB_SIZE";
    public static final String SHOW_LINE_NUMBERS = "showLineNumbers";
    public static final String SHOW_FILE_NAME = "showFileName";
    public static final String SHOW_TABLE_BORDER = "showTableBorder";
    private static JavaSourceConversionOptions defaultOptions;
    private JavaSourceStyleTable styleTable = JavaSourceStyleTable.getDefault();
    private int tabSize = 2;
    private boolean showLineNumbers = false;
    private boolean showFileName = false;
    private boolean showTableBorder = false;
    private boolean showJava2HtmlLink = false;
    private boolean addLineAnchors = false;
    private String lineAnchorPrefix = "";
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    static /* synthetic */ Class class$de$java2html$options$JavaSourceConversionOptions;

    public static JavaSourceConversionOptions getRawDefault() {
        return new JavaSourceConversionOptions();
    }

    public static JavaSourceConversionOptions getDefault() throws IllegalConfigurationException {
        if (defaultOptions == null) {
            defaultOptions = JavaSourceConversionOptions.createDefaultOptions();
        }
        return defaultOptions.getClone();
    }

    private static JavaSourceConversionOptions createDefaultOptions() throws IllegalConfigurationException {
        InputStream inputStream = (class$de$java2html$options$JavaSourceConversionOptions == null ? (class$de$java2html$options$JavaSourceConversionOptions = JavaSourceConversionOptions.class$("de.java2html.options.JavaSourceConversionOptions")) : class$de$java2html$options$JavaSourceConversionOptions).getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);
        if (inputStream == null) {
            return new JavaSourceConversionOptions();
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            JavaSourceConversionOptions javaSourceConversionOptions = new ConversionOptionsPropertiesReader().read(properties);
            return javaSourceConversionOptions;
        }
        catch (IOException exception) {
            throw new IllegalConfigurationException("Error loading configuration file 'java2html.properties' from classpath", exception);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalConfigurationException("Error loading configuration file 'java2html.properties' from classpath", exception);
        }
        finally {
            IoUtilities.close(inputStream);
        }
    }

    private JavaSourceConversionOptions() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaSourceConversionOptions)) {
            return false;
        }
        JavaSourceConversionOptions other = (JavaSourceConversionOptions)obj;
        return other.tabSize == this.tabSize && other.styleTable.equals(this.styleTable) && other.showFileName == this.showFileName && other.showJava2HtmlLink == this.showJava2HtmlLink && other.showLineNumbers == this.showLineNumbers && other.showTableBorder == this.showTableBorder && other.horizontalAlignment == this.horizontalAlignment;
    }

    public int hashCode() {
        return this.styleTable.hashCode() + this.tabSize;
    }

    public JavaSourceConversionOptions getClone() {
        JavaSourceConversionOptions options = new JavaSourceConversionOptions();
        options.styleTable = this.styleTable.getClone();
        options.tabSize = this.tabSize;
        options.showLineNumbers = this.showLineNumbers;
        options.showFileName = this.showFileName;
        options.showJava2HtmlLink = this.showJava2HtmlLink;
        options.showTableBorder = this.showTableBorder;
        options.horizontalAlignment = this.horizontalAlignment;
        return options;
    }

    public void setStyleTable(JavaSourceStyleTable styleTable) {
        Ensure.ensureArgumentNotNull(styleTable);
        this.styleTable = styleTable;
    }

    public JavaSourceStyleTable getStyleTable() {
        return this.styleTable;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public boolean isShowLineNumbers() {
        return this.showLineNumbers;
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.showLineNumbers = showLineNumbers;
    }

    public boolean isShowFileName() {
        return this.showFileName;
    }

    public boolean isShowTableBorder() {
        return this.showTableBorder;
    }

    public void setShowFileName(boolean showFileName) {
        this.showFileName = showFileName;
    }

    public void setShowTableBorder(boolean showTableBorder) {
        this.showTableBorder = showTableBorder;
    }

    public boolean isAddLineAnchors() {
        return this.addLineAnchors;
    }

    public String getLineAnchorPrefix() {
        return this.lineAnchorPrefix;
    }

    public void setAddLineAnchors(boolean addLineAnchors) {
        this.addLineAnchors = addLineAnchors;
    }

    public void setLineAnchorPrefix(String lineAnchorPrefix) {
        this.lineAnchorPrefix = lineAnchorPrefix;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        Ensure.ensureArgumentNotNull(horizontalAlignment);
        this.horizontalAlignment = horizontalAlignment;
    }

    public boolean isShowJava2HtmlLink() {
        return this.showJava2HtmlLink;
    }

    public void setShowJava2HtmlLink(boolean isShowJava2HtmlLink) {
        this.showJava2HtmlLink = isShowJava2HtmlLink;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

