/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.plugin.jspwiki.test;

import com.ecyrd.jspwiki.plugin.PluginException;
import de.java2html.plugin.jspwiki.PluginParameter;
import de.java2html.plugin.jspwiki.PluginParameterChecker;
import java.util.HashMap;
import junit.framework.TestCase;

public class PluginParameterCheckerTest
extends TestCase {
    private HashMap parameters = new HashMap();

    public void testEmptyParameterListIsSupported() throws PluginException {
        new PluginParameterChecker().checkParametersSupported(this.parameters);
    }

    public void testInternalParameterIsSupported() throws PluginException {
        this.parameters.put("_body", "");
        new PluginParameterChecker().checkParametersSupported(this.parameters);
    }

    public void testIllegalParameterIsNotSupported() {
        try {
            this.parameters.put("A very unsupported parameter am I", "");
            new PluginParameterChecker().checkParametersSupported(this.parameters);
            PluginParameterCheckerTest.fail();
        }
        catch (PluginException pluginException) {
            // empty catch block
        }
    }

    public void testValidParameterIsSupported() throws PluginException {
        this.parameters.put(PluginParameter.SOURCE.getName(), "");
        new PluginParameterChecker().checkParametersSupported(this.parameters);
    }

    public void testNonStringObjectIsSupported() throws PluginException {
        this.parameters.put(new Integer(42), "");
        new PluginParameterChecker().checkParametersSupported(this.parameters);
    }
}

