/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.properties.test;

import de.java2html.javasource.JavaSourceType;
import de.java2html.options.HorizontalAlignment;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleEntry;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.properties.ConversionOptionsPropertiesReader;
import de.java2html.properties.ConversionOptionsPropertiesWriter;
import de.java2html.properties.IllegalPropertyValueException;
import de.java2html.util.RGB;
import junit.framework.TestCase;

public class ConversionOptionsPropertiesPersistenceTest
extends TestCase {
    private JavaSourceConversionOptions options;

    protected void setUp() throws Exception {
        this.options = JavaSourceConversionOptions.getDefault();
    }

    public void testPersistDefaultOptions() throws IllegalPropertyValueException {
        ConversionOptionsPropertiesPersistenceTest.assertEquals((Object)this.options, (Object)this.writeAndRead(this.options));
    }

    public void testPersistDefaultStyleTableName() throws IllegalPropertyValueException {
        JavaSourceStyleTable styleTable = JavaSourceStyleTable.getDefaultKawaStyleTable();
        this.options.setStyleTable(styleTable);
        ConversionOptionsPropertiesPersistenceTest.assertEquals((String)styleTable.getName(), (String)this.writeAndRead(this.options).getStyleTable().getName());
    }

    public void testPersistTabSize() throws IllegalPropertyValueException {
        this.options.setTabSize(11);
        ConversionOptionsPropertiesPersistenceTest.assertEquals((int)11, (int)this.writeAndRead(this.options).getTabSize());
    }

    public void testPersistShowLineNumbers() throws IllegalPropertyValueException {
        this.options.setShowLineNumbers(!this.options.isShowLineNumbers());
        ConversionOptionsPropertiesPersistenceTest.assertEquals((boolean)this.options.isShowLineNumbers(), (boolean)this.writeAndRead(this.options).isShowLineNumbers());
    }

    public void testPersistShowJava2HtmlLink() throws IllegalPropertyValueException {
        this.options.setShowJava2HtmlLink(!this.options.isShowJava2HtmlLink());
        ConversionOptionsPropertiesPersistenceTest.assertEquals((boolean)this.options.isShowJava2HtmlLink(), (boolean)this.writeAndRead(this.options).isShowJava2HtmlLink());
    }

    public void testPersistShowFileName() throws IllegalPropertyValueException {
        this.options.setShowFileName(!this.options.isShowFileName());
        ConversionOptionsPropertiesPersistenceTest.assertEquals((boolean)this.options.isShowFileName(), (boolean)this.writeAndRead(this.options).isShowFileName());
    }

    public void testPersistShowTableBorder() throws IllegalPropertyValueException {
        this.options.setShowTableBorder(!this.options.isShowTableBorder());
        ConversionOptionsPropertiesPersistenceTest.assertEquals((boolean)this.options.isShowTableBorder(), (boolean)this.writeAndRead(this.options).isShowTableBorder());
    }

    public void testPersistHorizontalAlignment() throws IllegalPropertyValueException {
        this.options.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        ConversionOptionsPropertiesPersistenceTest.assertEquals((Object)this.options.getHorizontalAlignment(), (Object)this.writeAndRead(this.options).getHorizontalAlignment());
    }

    public void testPersistStyleEntry1() throws IllegalPropertyValueException {
        JavaSourceStyleEntry entry = new JavaSourceStyleEntry(RGB.MAGENTA, true, false);
        this.options.getStyleTable().put(JavaSourceType.COMMENT_LINE, entry);
        ConversionOptionsPropertiesPersistenceTest.assertEquals((Object)entry, (Object)this.writeAndRead(this.options).getStyleTable().get(JavaSourceType.COMMENT_LINE));
    }

    public void testPersistStyleEntry2() throws IllegalPropertyValueException {
        JavaSourceStyleEntry entry = new JavaSourceStyleEntry(RGB.GREEN, false, true);
        this.options.getStyleTable().put(JavaSourceType.COMMENT_LINE, entry);
        ConversionOptionsPropertiesPersistenceTest.assertEquals((Object)entry, (Object)this.writeAndRead(this.options).getStyleTable().get(JavaSourceType.COMMENT_LINE));
    }

    private JavaSourceConversionOptions writeAndRead(JavaSourceConversionOptions options) throws IllegalPropertyValueException {
        return new ConversionOptionsPropertiesReader().read(new ConversionOptionsPropertiesWriter().write(options));
    }
}

