/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.EnvVars;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class EnvironmentExpander
implements Serializable {
    public abstract void expand(@Nonnull EnvVars var1) throws IOException, InterruptedException;

    public static EnvironmentExpander constant(@Nonnull Map<String, String> env) {
        return new ConstantEnvironmentExpander(env);
    }

    public static EnvironmentExpander merge(@CheckForNull EnvironmentExpander original, @Nonnull EnvironmentExpander subsequent) {
        if (original == null) {
            return subsequent;
        }
        return new MergedEnvironmentExpander(original, subsequent);
    }

    @Nonnull
    public static EnvVars getEffectiveEnvironment(@Nonnull EnvVars customEnvironment, @CheckForNull EnvVars contextualEnvironment, @CheckForNull EnvironmentExpander expander) throws IOException, InterruptedException {
        EnvVars env;
        if (contextualEnvironment != null) {
            env = new EnvVars(contextualEnvironment);
            env.putAll((Map)customEnvironment);
        } else {
            env = new EnvVars(customEnvironment);
        }
        if (expander != null) {
            expander.expand(env);
        }
        return env;
    }

    private static class MergedEnvironmentExpander
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final EnvironmentExpander original;
        @Nonnull
        private final EnvironmentExpander subsequent;

        MergedEnvironmentExpander(EnvironmentExpander original, EnvironmentExpander subsequent) {
            this.original = original;
            this.subsequent = subsequent;
        }

        @Override
        public void expand(EnvVars env) throws IOException, InterruptedException {
            this.original.expand(env);
            this.subsequent.expand(env);
        }
    }

    private static class ConstantEnvironmentExpander
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> envMap = new HashMap<String, String>();

        ConstantEnvironmentExpander(@Nonnull Map<String, String> envMap) {
            this.envMap.putAll(envMap);
        }

        @Override
        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideAll(this.envMap);
        }
    }
}

