/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public abstract class SynchronousNonBlockingStepExecution<T>
extends StepExecution {
    private volatile transient Future<?> task;
    private transient String threadName;
    private transient boolean stopping;
    private static ExecutorService executorService;

    protected SynchronousNonBlockingStepExecution(@Nonnull StepContext context) {
        super(context);
    }

    protected abstract T run() throws Exception;

    @Override
    public final boolean start() throws Exception {
        final Authentication auth = Jenkins.getAuthentication();
        this.task = SynchronousNonBlockingStepExecution.getExecutorService().submit(new Runnable(){

            @Override
            @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="not serializing anything here")
            public void run() {
                block2: {
                    try {
                        SynchronousNonBlockingStepExecution.this.getContext().onSuccess(ACL.impersonate((Authentication)auth, (Callable)new NotReallyRoleSensitiveCallable<T, Exception>(){

                            public T call() throws Exception {
                                SynchronousNonBlockingStepExecution.this.threadName = Thread.currentThread().getName();
                                return SynchronousNonBlockingStepExecution.this.run();
                            }
                        }));
                    }
                    catch (Throwable e) {
                        if (SynchronousNonBlockingStepExecution.this.stopping) break block2;
                        SynchronousNonBlockingStepExecution.this.getContext().onFailure(e);
                    }
                }
            }
        });
        return false;
    }

    @Override
    public void stop(Throwable cause) throws Exception {
        if (this.task != null) {
            this.stopping = true;
            this.task.cancel(true);
        }
        super.stop(cause);
    }

    @Override
    public void onResume() {
        this.getContext().onFailure(new Exception("Resume after a restart not supported for non-blocking synchronous steps"));
    }

    @Override
    @Nonnull
    public String getStatus() {
        if (this.threadName != null) {
            return "running in thread: " + this.threadName;
        }
        return "not yet scheduled";
    }

    static synchronized ExecutorService getExecutorService() {
        if (executorService == null) {
            executorService = Executors.newCachedThreadPool((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), "org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution"));
        }
        return executorService;
    }
}

