/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Item;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class StaplerReferer {
    private static final Logger LOGGER = Logger.getLogger(StaplerReferer.class.getName());
    private static final Pattern REFERER = Pattern.compile(".+?((/job/[^/]+)+)/.+");

    @CheckForNull
    static String itemFromReferer(@Nonnull String referer) {
        Matcher m = REFERER.matcher(referer);
        if (m.matches()) {
            return URI.create(m.group(1).replace("/job/", "/")).getPath().substring(1);
        }
        return null;
    }

    @CheckForNull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="TODO 1.653+ switch to Jenkins.getInstanceOrNull")
    public static <T extends Item> T findItemFromRequest(Class<T> type) {
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request == null) {
            LOGGER.warning("no current request");
            return null;
        }
        Item ancestor = (Item)request.findAncestorObject(type);
        if (ancestor != null) {
            LOGGER.log(Level.FINE, "found {0} in {1}", new Object[]{ancestor, request.getRequestURI()});
            return (T)ancestor;
        }
        String referer = request.getReferer();
        if (referer != null) {
            String name = StaplerReferer.itemFromReferer(referer);
            if (name != null) {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins == null) {
                    LOGGER.warning("Jenkins is not running");
                    return null;
                }
                Item item = jenkins.getItemByFullName(name);
                if (type.isInstance(item)) {
                    LOGGER.log(Level.FINE, "found {0} from {1}", new Object[]{item, referer});
                    return (T)((Item)type.cast(item));
                }
                if (item != null) {
                    LOGGER.log(Level.FINE, "{0} was not a {1}", new Object[]{item, type.getName()});
                } else {
                    LOGGER.log(Level.WARNING, "no such item {0}", name);
                }
            } else {
                LOGGER.log(request.findAncestorObject(Item.class) == null ? Level.WARNING : Level.FINE, "unrecognized Referer: {0} from {1}", new Object[]{referer, request.getRequestURI()});
            }
        } else {
            LOGGER.log(Level.WARNING, "no Referer in {0}", request.getRequestURI());
        }
        return null;
    }

    private StaplerReferer() {
    }
}

