/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.jenkinsci.remoting.ChannelStateException;
import org.jenkinsci.remoting.RoleSensitive;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

public interface Callable<V, T extends Throwable>
extends Serializable,
RoleSensitive {
    public V call() throws T;

    @Nonnull
    default public Channel getChannelOrFail() throws ChannelStateException {
        Channel ch = Channel.current();
        if (ch == null) {
            Thread t = Thread.currentThread();
            throw new ChannelStateException(null, "The calling thread " + t + " has no associated channel. The current object " + this + " is " + SerializableOnlyOverRemoting.class + ", but it is likely being serialized/deserialized without the channel");
        }
        return ch;
    }

    @Nonnull
    default public Channel getOpenChannelOrFail() throws ChannelStateException {
        Channel ch = this.getChannelOrFail();
        if (ch.isClosingOrClosed()) {
            throw new ChannelClosedException(ch, "The associated channel " + ch + " is closing down or has closed down", ch.getCloseRequestCause());
        }
        return ch;
    }
}

