/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.Base64;
import hudson.remoting.Util;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.jenkinsci.remoting.engine.JnlpAgentEndpoint;
import org.jenkinsci.remoting.util.https.NoCheckHostnameVerifier;
import org.jenkinsci.remoting.util.https.NoCheckTrustManager;

public class JnlpAgentEndpointResolver {
    private static final Logger LOGGER = Logger.getLogger(JnlpAgentEndpointResolver.class.getName());
    @Nonnull
    private final List<String> jenkinsUrls;
    private SSLSocketFactory sslSocketFactory;
    private String credentials;
    private String proxyCredentials;
    private String tunnel;
    private boolean disableHttpsCertValidation;
    private static String PROTOCOL_NAMES_TO_TRY = System.getProperty(JnlpAgentEndpointResolver.class.getName() + ".protocolNamesToTry");

    public JnlpAgentEndpointResolver(String ... jenkinsUrls) {
        this.jenkinsUrls = new ArrayList<String>(Arrays.asList(jenkinsUrls));
    }

    public JnlpAgentEndpointResolver(@Nonnull List<String> jenkinsUrls) {
        this.jenkinsUrls = new ArrayList<String>(jenkinsUrls);
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void setCredentials(String user, String pass) {
        this.credentials = user + ":" + pass;
    }

    public String getProxyCredentials() {
        return this.proxyCredentials;
    }

    public void setProxyCredentials(String proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
    }

    public void setProxyCredentials(String user, String pass) {
        this.proxyCredentials = user + ":" + pass;
    }

    public String getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    public boolean isDisableHttpsCertValidation() {
        return this.disableHttpsCertValidation;
    }

    public void setDisableHttpsCertValidation(boolean disableHttpsCertValidation) {
        this.disableHttpsCertValidation = disableHttpsCertValidation;
    }

    /*
     * Exception decompiling
     */
    @CheckForNull
    public JnlpAgentEndpoint resolve() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK], 16[CATCHBLOCK], 6[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    private URL toAgentListenerURL(@Nonnull String jenkinsUrl) throws MalformedURLException {
        return jenkinsUrl.endsWith("/") ? new URL(jenkinsUrl + "tcpSlaveAgentListener/") : new URL(jenkinsUrl + "/tcpSlaveAgentListener/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForReady() throws InterruptedException {
        Thread t = Thread.currentThread();
        String oldName = t.getName();
        try {
            int retries = 0;
            while (true) {
                String firstUrl;
                block10: {
                    Thread.sleep(10000L);
                    firstUrl = JnlpAgentEndpointResolver.first(this.jenkinsUrls);
                    if (firstUrl != null) break block10;
                    t.setName(oldName);
                    return;
                }
                URL url = this.toAgentListenerURL(firstUrl);
                t.setName(oldName + ": trying " + url + " for " + ++retries + " times");
                HttpURLConnection con = (HttpURLConnection)JnlpAgentEndpointResolver.openURLConnection(url, this.credentials, this.proxyCredentials, this.sslSocketFactory, this.disableHttpsCertValidation);
                con.setConnectTimeout(5000);
                con.setReadTimeout(5000);
                con.connect();
                if (con.getResponseCode() == 200) {
                    t.setName(oldName);
                    return;
                }
                try {
                    LOGGER.log(Level.INFO, "Master isn''t ready to talk to us on {0}. Will try again: response code={1}", new Object[]{url, con.getResponseCode()});
                }
                catch (ConnectException | NoRouteToHostException | SocketTimeoutException e) {
                    LOGGER.log(Level.INFO, "Failed to connect to the master. Will try again: {0} {1}", new String[]{e.getClass().getName(), e.getMessage()});
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Failed to connect to the master. Will try again", e);
                }
                continue;
                break;
            }
        }
        catch (Throwable throwable) {
            t.setName(oldName);
            throw throwable;
        }
    }

    @CheckForNull
    static InetSocketAddress getResolvedHttpProxyAddress(@Nonnull String host, int port) throws IOException {
        String httpProxy;
        InetSocketAddress targetAddress = null;
        Iterator<Proxy> proxies = ProxySelector.getDefault().select(URI.create(String.format("http://%s:%d", host, port))).iterator();
        while (targetAddress == null && proxies.hasNext()) {
            String nonProxyHosts;
            Proxy proxy = proxies.next();
            if (proxy.type() == Proxy.Type.DIRECT && (nonProxyHosts = System.getProperty("http.nonProxyHosts")) != null && nonProxyHosts.length() != 0) {
                StringJoiner sj = new StringJoiner("|");
                nonProxyHosts = nonProxyHosts.toLowerCase(Locale.ENGLISH);
                for (String entry : nonProxyHosts.split("\\|")) {
                    if (entry.isEmpty()) continue;
                    if (entry.startsWith("*")) {
                        sj.add(".*" + Pattern.quote(entry.substring(1)));
                    } else if (entry.endsWith("*")) {
                        sj.add(Pattern.quote(entry.substring(0, entry.length() - 1)) + ".*");
                    } else {
                        sj.add(Pattern.quote(entry));
                    }
                    if (entry.split("\\*").length <= 2) continue;
                    LOGGER.log(Level.WARNING, "Using more than one wildcard is not supported in nonProxyHosts entries: {0}", entry);
                }
                Pattern nonProxyRegexps = Pattern.compile(sj.toString());
                if (!nonProxyRegexps.matcher(host.toLowerCase(Locale.ENGLISH)).matches()) break;
                return null;
            }
            if (proxy.type() != Proxy.Type.HTTP) continue;
            SocketAddress address = proxy.address();
            if (!(address instanceof InetSocketAddress)) {
                LOGGER.log(Level.WARNING, "Unsupported proxy address type {0}", address != null ? address.getClass() : "null");
                continue;
            }
            InetSocketAddress proxyAddress = (InetSocketAddress)address;
            if (proxyAddress.isUnresolved()) {
                proxyAddress = new InetSocketAddress(proxyAddress.getHostName(), proxyAddress.getPort());
            }
            targetAddress = proxyAddress;
        }
        if (targetAddress == null && (httpProxy = System.getenv("http_proxy")) != null && !JnlpAgentEndpointResolver.inNoProxyEnvVar(host)) {
            try {
                URL url = new URL(httpProxy);
                targetAddress = new InetSocketAddress(url.getHost(), url.getPort());
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "Not using http_proxy environment variable which is invalid.", e);
            }
        }
        return targetAddress;
    }

    static URLConnection openURLConnection(URL url, String credentials, String proxyCredentials, SSLSocketFactory sslSocketFactory, boolean disableHttpsCertValidation) throws IOException {
        String encoding;
        String httpProxy = null;
        if (System.getProperty("http.proxyHost") == null) {
            httpProxy = System.getenv("http_proxy");
        }
        URLConnection con = null;
        if (httpProxy != null && "http".equals(url.getProtocol()) && !JnlpAgentEndpointResolver.inNoProxyEnvVar(url.getHost())) {
            try {
                URL proxyUrl = new URL(httpProxy);
                InetSocketAddress addr = new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                con = url.openConnection(proxy);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "Not using http_proxy environment variable which is invalid.", e);
                con = url.openConnection();
            }
        } else {
            con = url.openConnection();
        }
        if (credentials != null) {
            encoding = Base64.encode(credentials.getBytes("UTF-8"));
            con.setRequestProperty("Authorization", "Basic " + encoding);
        }
        if (proxyCredentials != null) {
            encoding = Base64.encode(proxyCredentials.getBytes("UTF-8"));
            con.setRequestProperty("Proxy-Authorization", "Basic " + encoding);
        }
        if (con instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)con;
            if (disableHttpsCertValidation) {
                LOGGER.log(Level.WARNING, "HTTPs certificate check is disabled for the endpoint.");
                try {
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    ctx.init(null, new TrustManager[]{new NoCheckTrustManager()}, new SecureRandom());
                    sslSocketFactory = ctx.getSocketFactory();
                    httpsConnection.setHostnameVerifier(new NoCheckHostnameVerifier());
                    httpsConnection.setSSLSocketFactory(sslSocketFactory);
                }
                catch (KeyManagementException | NoSuchAlgorithmException ex) {
                    throw new IOException("Cannot initialize the insecure HTTPs mode", ex);
                }
            } else if (sslSocketFactory != null) {
                httpsConnection.setSSLSocketFactory(sslSocketFactory);
                httpsConnection.setHostnameVerifier(new NoCheckHostnameVerifier());
            }
        }
        return con;
    }

    static boolean inNoProxyEnvVar(String host) {
        return Util.inNoProxyEnvVar(host);
    }

    @CheckForNull
    private static List<String> header(@Nonnull HttpURLConnection connection, String ... headerNames) {
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        for (String headerName : headerNames) {
            for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
                String headerField = entry.getKey();
                if (headerField == null || !headerField.equalsIgnoreCase(headerName)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @CheckForNull
    private static String first(@CheckForNull List<String> values) {
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    @Nonnull
    private static String defaultString(@CheckForNull String value, @Nonnull String defaultValue) {
        return value == null ? defaultValue : value;
    }
}

