/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.cert;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jenkinsci.remoting.protocol.cert.BlindTrustX509ExtendedTrustManager;

@IgnoreJRERequirement
public class ValidityCheckingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    @Nonnull
    private final X509ExtendedTrustManager delegate;

    public ValidityCheckingX509ExtendedTrustManager() {
        this(new BlindTrustX509ExtendedTrustManager());
    }

    public ValidityCheckingX509ExtendedTrustManager(@Nonnull X509ExtendedTrustManager delegate) {
        this.delegate = delegate;
    }

    private static void validateAuthType(String authType) {
        if (authType == null) {
            throw new IllegalArgumentException("authType must not be null");
        }
        if (authType.isEmpty()) {
            throw new IllegalArgumentException("authType must not be zero-length");
        }
    }

    private static void validateChain(X509Certificate[] chain) {
        if (chain == null) {
            throw new IllegalArgumentException("chain must not be null");
        }
        if (chain.length == 0) {
            throw new IllegalArgumentException("chain must not be zero-length");
        }
    }

    private static void checkValidity(X509Certificate[] chain) throws CertificateExpiredException, CertificateNotYetValidException {
        for (X509Certificate cert : chain) {
            cert.checkValidity();
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        ValidityCheckingX509ExtendedTrustManager.validateAuthType(authType);
        ValidityCheckingX509ExtendedTrustManager.validateChain(chain);
        ValidityCheckingX509ExtendedTrustManager.checkValidity(chain);
        this.delegate.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        ValidityCheckingX509ExtendedTrustManager.validateAuthType(authType);
        ValidityCheckingX509ExtendedTrustManager.validateChain(chain);
        ValidityCheckingX509ExtendedTrustManager.checkValidity(chain);
        this.delegate.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        ValidityCheckingX509ExtendedTrustManager.validateAuthType(authType);
        ValidityCheckingX509ExtendedTrustManager.validateChain(chain);
        ValidityCheckingX509ExtendedTrustManager.checkValidity(chain);
        this.delegate.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        ValidityCheckingX509ExtendedTrustManager.validateAuthType(authType);
        ValidityCheckingX509ExtendedTrustManager.validateChain(chain);
        ValidityCheckingX509ExtendedTrustManager.checkValidity(chain);
        this.delegate.checkServerTrusted(chain, authType, engine);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ValidityCheckingX509ExtendedTrustManager.validateAuthType(authType);
        ValidityCheckingX509ExtendedTrustManager.validateChain(chain);
        ValidityCheckingX509ExtendedTrustManager.checkValidity(chain);
        this.delegate.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ValidityCheckingX509ExtendedTrustManager.validateAuthType(authType);
        ValidityCheckingX509ExtendedTrustManager.validateChain(chain);
        ValidityCheckingX509ExtendedTrustManager.checkValidity(chain);
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

