/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import java.io.Serializable;
import java.net.URI;
import javax.annotation.Nonnull;

public class MercurialCommitPayload
implements Serializable {
    @Nonnull
    private final URI url;
    @Nonnull
    private final String branch;
    @Nonnull
    private final String changesetId;

    public MercurialCommitPayload(@Nonnull URI url, @Nonnull String branch, @Nonnull String commitId) {
        this.url = url;
        this.branch = branch;
        this.changesetId = commitId;
    }

    @Nonnull
    public URI getUrl() {
        return this.url;
    }

    @Nonnull
    public String getBranch() {
        return this.branch;
    }

    @Nonnull
    public String getChangesetId() {
        return this.changesetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MercurialCommitPayload that = (MercurialCommitPayload)o;
        if (!this.url.equals(that.url)) {
            return false;
        }
        if (!this.branch.equals(that.branch)) {
            return false;
        }
        return this.changesetId.equals(that.changesetId);
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.branch.hashCode();
        result = 31 * result + this.changesetId.hashCode();
        return result;
    }

    public String toString() {
        return "MercurialCommitPayload{url='" + this.url + '\'' + ", branch='" + this.branch + '\'' + ", commitId='" + this.changesetId + '\'' + '}';
    }
}

