/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.Messages;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@SuppressWarnings(value={"SE_NO_SERIALVERSIONID"})
public class MercurialInstallation
extends ToolInstallation
implements NodeSpecific<MercurialInstallation>,
EnvironmentSpecific<MercurialInstallation> {
    @Deprecated
    private transient String downloadForest;
    private String executable;
    private boolean debug;
    private boolean useCaches;
    private final String masterCacheRoot;
    private boolean useSharing;
    private final String config;

    @Deprecated
    public MercurialInstallation(String name, String home, String executable, boolean debug, boolean useCaches, boolean useSharing, @CheckForNull List<? extends ToolProperty<?>> properties) {
        this(name, home, executable, debug, useCaches, null, useSharing, null, properties);
    }

    @Deprecated
    public MercurialInstallation(String name, String home, String executable, boolean debug, boolean useCaches, boolean useSharing, String config, @CheckForNull List<? extends ToolProperty<?>> properties) {
        this(name, home, executable, debug, useCaches, null, useSharing, config, properties);
    }

    @DataBoundConstructor
    public MercurialInstallation(String name, String home, String executable, boolean debug, boolean useCaches, String masterCacheRoot, boolean useSharing, String config, @CheckForNull List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
        this.executable = Util.fixEmpty((String)executable);
        this.debug = debug;
        this.useCaches = useCaches || useSharing;
        this.masterCacheRoot = Util.fixEmptyAndTrim((String)masterCacheRoot);
        this.config = Util.fixEmptyAndTrim((String)config);
        this.useSharing = useSharing;
    }

    public String getExecutable() {
        return this.executable != null ? this.executable : "INSTALLATION/bin/hg";
    }

    String executableWithSubstitution(String home) {
        String _executable = this.getExecutable();
        if (home.isEmpty() && _executable.contains("INSTALLATION")) {
            return "hg";
        }
        return _executable.replace("INSTALLATION", home);
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean isUseCaches() {
        return this.useCaches;
    }

    public String getMasterCacheRoot() {
        return this.masterCacheRoot;
    }

    public boolean isUseSharing() {
        return this.useSharing;
    }

    @CheckForNull
    public String getConfig() {
        return this.config;
    }

    @NonNull
    public static MercurialInstallation[] allInstallations() {
        return ((DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class)).getInstallations();
    }

    public MercurialInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new MercurialInstallation(this.getName(), this.translateFor(node, log), this.executable, this.debug, this.useCaches, this.useSharing, this.getProperties().toList());
    }

    public MercurialInstallation forEnvironment(EnvVars environment) {
        return new MercurialInstallation(this.getName(), environment.expand(this.getHome()), this.executable, this.debug, this.useCaches, this.useSharing, this.getProperties().toList());
    }

    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<MercurialInstallation> {
        @SuppressWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"})
        private volatile MercurialInstallation[] installations = new MercurialInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.MercurialInstallation_mercurial();
        }

        @SuppressWarnings(value={"EI_EXPOSE_REP"})
        public MercurialInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(MercurialInstallation ... installations) {
            this.installations = installations;
            this.save();
        }

        public FormValidation doCheckConfig(@QueryParameter String value) {
            if (value == null) {
                return FormValidation.ok();
            }
            try {
                new Ini((Reader)new StringReader(value));
                return FormValidation.ok();
            }
            catch (InvalidFileFormatException x) {
                return FormValidation.error((String)x.getMessage());
            }
            catch (IOException x) {
                return FormValidation.error((Throwable)x, (String)"should not happen");
            }
        }
    }
}

