/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.Cache;
import hudson.plugins.mercurial.ChangeComparator;
import hudson.plugins.mercurial.HgExe;
import hudson.plugins.mercurial.MercurialChangeLogParser;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialTagAction;
import hudson.plugins.mercurial.Messages;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.plugins.mercurial.browser.HgWeb;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.ArgumentListBuilder;
import hudson.util.ForkOutputStream;
import hudson.util.ListBoxModel;
import hudson.util.LogTaskListener;
import hudson.util.VersionNumber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.multiplescms.MultiSCMRevisionState;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class MercurialSCM
extends SCM
implements Serializable {
    private static final String ENV_MERCURIAL_REVISION = "MERCURIAL_REVISION";
    private static final String ENV_MERCURIAL_REVISION_SHORT = "MERCURIAL_REVISION_SHORT";
    private static final String ENV_MERCURIAL_REVISION_NUMBER = "MERCURIAL_REVISION_NUMBER";
    private static final String ENV_MERCURIAL_REVISION_BRANCH = "MERCURIAL_REVISION_BRANCH";
    private static final String ENV_MERCURIAL_REPOSITORY_URL = "MERCURIAL_REPOSITORY_URL";
    @Deprecated
    private transient boolean forest;
    private String installation;
    private final String source;
    private transient Set<String> _modules;
    private String modules = "";
    private RevisionType revisionType = RevisionType.BRANCH;
    private String revision = "default";
    @Deprecated
    private String branch;
    private String subdir;
    private boolean clean;
    private HgBrowser browser;
    private String credentialsId;
    private boolean disableChangeLog;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MercurialSCM.class.getName());

    @DataBoundConstructor
    public MercurialSCM(String source) {
        this.source = Util.fixEmptyAndTrim((String)source);
    }

    @Deprecated
    public MercurialSCM(String installation, String source, String branch, String modules, String subdir, HgBrowser browser, boolean clean) {
        this(installation, source, branch, modules, subdir, browser, clean, null);
    }

    @Deprecated
    public MercurialSCM(String installation, String source, String branch, String modules, String subdir, HgBrowser browser, boolean clean, String credentialsId) {
        this(installation, source, RevisionType.BRANCH, branch, modules, subdir, browser, clean, credentialsId);
    }

    @Deprecated
    public MercurialSCM(String installation, String source, @NonNull RevisionType revisionType, @NonNull String revision, String modules, String subdir, HgBrowser browser, boolean clean, String credentialsId) {
        this(installation, source, revisionType, revision, modules, subdir, browser, clean, credentialsId, false);
    }

    @Deprecated
    public MercurialSCM(String installation, String source, @NonNull RevisionType revisionType, @NonNull String revision, String modules, String subdir, HgBrowser browser, boolean clean, String credentialsId, boolean disableChangeLog) {
        this(source);
        this.setInstallation(installation);
        this.setModules(modules);
        this.setSubdir(subdir);
        this.setClean(clean);
        this.setRevisionType(revisionType);
        this.setRevision(revision);
        this.setBrowser(browser);
        this.setCredentialsId(credentialsId);
        this.setDisableChangeLog(disableChangeLog);
    }

    private void parseModules() {
        if (this.modules.trim().length() > 0) {
            this._modules = new HashSet<String>();
            for (String r : this.modules.split("(?<!\\\\)[ \\r\\n,]+")) {
                if (r.length() == 0) continue;
                r = r.replaceAll("\\\\ ", " ");
                while (r.startsWith("/")) {
                    r = r.substring(1);
                }
                r = r.replace('\\', '/');
                this._modules.add(r);
            }
        } else {
            this._modules = null;
        }
    }

    private Object readResolve() {
        if (this.revisionType == null) {
            this.revisionType = RevisionType.BRANCH;
            assert (this.revision == null);
            this.revision = this.branch == null ? "default" : this.branch;
            this.branch = null;
        }
        this.parseModules();
        return this;
    }

    public String getInstallation() {
        return this.installation;
    }

    @DataBoundSetter
    public final void setInstallation(String installation) {
        this.installation = installation;
    }

    public String getSource() {
        return this.source;
    }

    private String getSource(EnvVars env) {
        return env.expand(this.source);
    }

    public String getKey() {
        String base = "hg " + this.getSource(new EnvVars());
        if (this.revisionType == RevisionType.CHANGESET) {
            return base;
        }
        return base + " " + this.revision;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public final void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public boolean isDisableChangeLog() {
        return this.disableChangeLog;
    }

    @DataBoundSetter
    public final void setDisableChangeLog(boolean disableChangeLog) {
        this.disableChangeLog = disableChangeLog;
    }

    @CheckForNull
    StandardUsernameCredentials getCredentials(Job<?, ?> owner, EnvVars env) {
        if (this.credentialsId != null) {
            for (StandardUsernameCredentials standardUsernameCredentials : MercurialSCM.availableCredentials(owner, this.getSource(env))) {
                if (!standardUsernameCredentials.getId().equals(this.credentialsId)) continue;
                return standardUsernameCredentials;
            }
        }
        return null;
    }

    @NonNull
    public RevisionType getRevisionType() {
        return this.revisionType;
    }

    @DataBoundSetter
    public final void setRevisionType(@NonNull RevisionType revisionType) {
        this.revisionType = revisionType;
    }

    @NonNull
    public String getRevision() {
        return this.revision;
    }

    @DataBoundSetter
    public final void setRevision(@NonNull String revision) {
        this.revision = Util.fixEmpty((String)revision) == null ? "default" : revision;
    }

    @Deprecated
    public String getBranch() {
        if (this.revisionType != RevisionType.BRANCH) {
            throw new IllegalStateException();
        }
        return this.revision;
    }

    private String getRevisionExpanded(Job<?, ?> project, EnvVars env) {
        ParametersDefinitionProperty params = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (params != null) {
            for (ParameterDefinition param : params.getParameterDefinitions()) {
                String dflt;
                if (!(param instanceof StringParameterDefinition) || (dflt = ((StringParameterDefinition)param).getDefaultValue()) == null) continue;
                env.put(param.getName(), dflt);
            }
        }
        return this.getRevision(env);
    }

    private String getRevision(EnvVars env) {
        return env.expand(this.revision);
    }

    public String getSubdir() {
        return this.subdir;
    }

    @DataBoundSetter
    public final void setSubdir(String subdir) {
        this.subdir = Util.fixEmptyAndTrim((String)subdir);
    }

    private String getSubdir(EnvVars env) {
        return env.expand(this.subdir);
    }

    private FilePath workspace2Repo(FilePath workspace, EnvVars env) {
        return this.subdir != null ? workspace.child(env.expand(this.subdir)) : workspace;
    }

    public HgBrowser getBrowser() {
        return this.browser;
    }

    @DataBoundSetter
    public final void setBrowser(HgBrowser browser) {
        this.browser = browser;
    }

    public RepositoryBrowser<?> guessBrowser() {
        try {
            return new HgWeb(this.getSource(new EnvVars()));
        }
        catch (MalformedURLException x) {
            LOGGER.log(Level.FINE, null, x);
            return null;
        }
    }

    public boolean isClean() {
        return this.clean;
    }

    @DataBoundSetter
    public final void setClean(boolean clean) {
        this.clean = clean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment(listener);
        if (workspace == null) {
            throw new IOException("Workspace is not specified");
        }
        Node nodeWithTheWorkspace = MercurialSCM.workspaceToNode(workspace);
        if (nodeWithTheWorkspace == null) {
            throw new IOException("Cannot find a node for the specified workspace");
        }
        try (HgExe hg = new HgExe(MercurialSCM.findInstallation(this.getInstallation()), this.getCredentials(build.getParent(), env), launcher, nodeWithTheWorkspace, listener, env);){
            String tip = hg.tip(this.workspace2Repo(workspace, env), null);
            String rev = hg.tipNumber(this.workspace2Repo(workspace, env), null);
            String branch = this.revisionType != RevisionType.BRANCH ? hg.branch(this.workspace2Repo(workspace, env), null) : null;
            MercurialTagAction mercurialTagAction = tip != null && rev != null ? new MercurialTagAction(tip, rev, this.getSubdir(env), branch) : null;
            return mercurialTagAction;
        }
    }

    public boolean requiresWorkspaceForPolling() {
        MercurialInstallation mercurialInstallation = MercurialSCM.findInstallation(this.installation);
        return mercurialInstallation == null || !mercurialInstallation.isUseCaches() && !mercurialInstallation.isUseSharing();
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState _baseline) throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IOException("Jenkins instance is not ready");
        }
        if (!(_baseline instanceof MercurialTagAction)) {
            throw new IOException("SCM revision state is not a Mercurial one");
        }
        MercurialTagAction baseline = (MercurialTagAction)_baseline;
        PrintStream output = listener.getLogger();
        EnvVars env = project.getEnvironment((Node)jenkins, listener);
        StandardUsernameCredentials credentials = this.getCredentials(project, env);
        if (!this.requiresWorkspaceForPolling()) {
            launcher = jenkins.createLauncher(listener);
            CachedRepo possiblyCachedRepo = this.cachedSource((Node)Jenkins.getInstance(), env, launcher, listener, true, credentials);
            if (possiblyCachedRepo == null) {
                throw new IOException("Could not use cache to poll for changes. See error messages above for more details");
            }
            FilePath repositoryCache = new FilePath(new File(possiblyCachedRepo.getRepoLocation()));
            return this.compare(launcher, listener, baseline, output, (Node)jenkins, repositoryCache, project);
        }
        try {
            Node node = MercurialSCM.workspaceToNode(workspace);
            FilePath repository = this.workspace2Repo(workspace, env);
            this.pull(launcher, repository, listener, node, this.getRevisionExpanded(project, env), credentials, env);
            return this.compare(launcher, listener, baseline, output, node, repository, project);
        }
        catch (IOException e) {
            if (this.causedByMissingHg(e)) {
                listener.error(Messages.MercurialSCM_failed_to_compare_with_remote_repository());
                throw new AbortException("Failed to compare with remote repository");
            }
            throw new IOException("Failed to compare with remote repository", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PollingResult compare(Launcher launcher, TaskListener listener, MercurialTagAction baseline, PrintStream output, Node node, FilePath repository, Job<?, ?> project) throws IOException, InterruptedException {
        PollingResult.Change change = null;
        for (ChangeComparator s : ChangeComparator.all()) {
            PollingResult.Change c = s.compare(this, launcher, listener, baseline, output, node, repository, project);
            if (c == null || change != null && c.compareTo((Enum)change) <= 0) continue;
            change = c;
        }
        if (change != null) {
            return new PollingResult(change);
        }
        EnvVars env = project.getEnvironment(node, listener);
        try (HgExe hg = new HgExe(MercurialSCM.findInstallation(this.getInstallation()), this.getCredentials(project, env), launcher, node, listener, env);){
            String branch;
            String _revision = this.getRevisionExpanded(project, env);
            String remote = hg.tip(repository, _revision);
            String rev = hg.tipNumber(repository, _revision);
            String string = branch = this.revisionType != RevisionType.BRANCH ? hg.branch(repository, _revision) : null;
            if (remote == null) {
                throw new IOException("failed to find ID of branch head");
            }
            if (rev == null) {
                throw new IOException("failed to find revision of branch head");
            }
            if (remote.equals(baseline.id)) {
                PollingResult pollingResult = new PollingResult((SCMRevisionState)baseline, (SCMRevisionState)new MercurialTagAction(remote, rev, this.getSubdir(env), branch), PollingResult.Change.NONE);
                return pollingResult;
            }
            Set<String> changedFileNames = MercurialSCM.parseStatus(hg.popen(repository, listener, false, new ArgumentListBuilder(new String[]{"status", "--rev", baseline.id, "--rev", remote})));
            MercurialTagAction cur = new MercurialTagAction(remote, rev, this.getSubdir(env), branch);
            PollingResult pollingResult = new PollingResult((SCMRevisionState)baseline, (SCMRevisionState)cur, this.computeDegreeOfChanges(changedFileNames, output));
            return pollingResult;
        }
    }

    static Set<String> parseStatus(String status) {
        HashSet<String> result = new HashSet<String>();
        Matcher m = Pattern.compile("(?m)^[ARM] (.+)").matcher(status);
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pull(Launcher launcher, FilePath repository, TaskListener listener, Node node, String revision, StandardUsernameCredentials credentials, EnvVars env) throws IOException, InterruptedException {
        try (HgExe hg = new HgExe(MercurialSCM.findInstallation(this.getInstallation()), credentials, launcher, node, listener, env);){
            CachedRepo cachedSource;
            ArgumentListBuilder cmd = hg.seed(true);
            cmd.add("pull");
            if (this.revisionType == RevisionType.BRANCH || this.revisionType == RevisionType.CHANGESET) {
                cmd.add(new String[]{"--rev", revision});
            }
            if ((cachedSource = this.cachedSource(node, env, launcher, listener, true, credentials)) != null) {
                cmd.add(cachedSource.getRepoLocation());
            }
            int n = HgExe.joinWithPossibleTimeout(hg.launch(cmd).pwd(repository), true, listener);
            return n;
        }
    }

    private PollingResult.Change computeDegreeOfChanges(Set<String> changedFileNames, PrintStream output) {
        LOGGER.log(Level.FINE, "Changed file names: {0}", changedFileNames);
        if (changedFileNames.isEmpty()) {
            return PollingResult.Change.NONE;
        }
        Set<String> depchanges = this.dependentChanges(changedFileNames);
        LOGGER.log(Level.FINE, "Dependent changed file names: {0}", depchanges);
        if (depchanges.isEmpty()) {
            output.println(Messages.MercurialSCM_non_dependent_changes_detected());
            return PollingResult.Change.INSIGNIFICANT;
        }
        output.println(Messages.MercurialSCM_dependent_changes_detected());
        return PollingResult.Change.SIGNIFICANT;
    }

    private Set<String> dependentChanges(Set<String> changedFileNames) {
        HashSet<String> affecting = new HashSet<String>();
        block0: for (String changedFile : changedFileNames) {
            if (changedFile.matches("[.]hg(ignore|tags)")) continue;
            if (this._modules == null) {
                affecting.add(changedFile);
                continue;
            }
            String unixChangedFile = changedFile.replace('\\', '/');
            for (String dependency : this._modules) {
                if (!unixChangedFile.startsWith(dependency)) continue;
                affecting.add(changedFile);
                continue block0;
            }
        }
        return affecting;
    }

    @CheckForNull
    public static MercurialInstallation findInstallation(String name) {
        for (MercurialInstallation inst : MercurialInstallation.allInstallations()) {
            if (!inst.getName().equals(name)) continue;
            return inst;
        }
        return null;
    }

    public void checkout(Run<?, ?> build, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        boolean canReuseExistingWorkspace;
        MercurialInstallation mercurialInstallation = MercurialSCM.findInstallation(this.installation);
        boolean jobShouldUseSharing = mercurialInstallation != null && mercurialInstallation.isUseSharing();
        Node node = MercurialSCM.workspaceToNode(workspace);
        FilePath repository = this.workspace2Repo(workspace, build.getEnvironment(listener));
        try {
            canReuseExistingWorkspace = this.canReuseWorkspace(repository, node, jobShouldUseSharing, build, launcher, listener);
        }
        catch (IOException e) {
            if (this.causedByMissingHg(e)) {
                listener.error("Failed to determine whether workspace can be reused because hg could not be found; check that you've properly configured your Mercurial installation");
            } else {
                e.printStackTrace(listener.error("Failed to determine whether workspace can be reused"));
            }
            throw new AbortException("Failed to determine whether workspace can be reused");
        }
        String revToBuild = this.getRevToBuild(build, workspace, build.getEnvironment(listener));
        StandardUsernameCredentials credentials = this.getCredentials(build.getParent(), build.getEnvironment(listener));
        if (canReuseExistingWorkspace) {
            this.update(build, launcher, repository, node, listener, revToBuild, credentials);
        } else {
            this.clone(build, launcher, repository, node, listener, revToBuild, credentials);
        }
        if (changelogFile != null) {
            try {
                this.determineChanges(build, launcher, listener, changelogFile, repository, node, revToBuild, baseline);
            }
            catch (IOException e) {
                listener.error("Failed to capture change log");
                e.printStackTrace(listener.getLogger());
                throw new AbortException("Failed to capture change log");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canReuseWorkspace(FilePath repo, Node node, boolean jobShouldUseSharing, Run<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean jobUsesSharing = new FilePath(repo, ".hg/sharedpath").exists();
        if (jobShouldUseSharing != jobUsesSharing) {
            return false;
        }
        if (jobUsesSharing) {
            return true;
        }
        if (!new FilePath(repo, ".hg/hgrc").exists()) {
            return false;
        }
        try (HgExe hg = new HgExe(MercurialSCM.findInstallation(this.getInstallation()), this.getCredentials(build.getParent(), build.getEnvironment(listener)), launcher, node, listener, build.getEnvironment(listener));){
            String upstream = hg.config(repo, "paths.default");
            EnvVars env = build.getEnvironment(listener);
            if (HgExe.pathEquals(this.getSource(env), upstream)) {
                boolean bl = true;
                return bl;
            }
            listener.error("Workspace reports paths.default as " + upstream + "\nwhich looks different than " + this.getSource(env) + "\nso falling back to fresh clone rather than incremental update");
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineChanges(Run<?, ?> build, Launcher launcher, TaskListener listener, @Nonnull File changelogFile, FilePath repository, Node node, String revToBuild, SCMRevisionState baseline) throws IOException, InterruptedException {
        if (this.isDisableChangeLog()) {
            this.createEmptyChangeLog(changelogFile, listener, "changelog");
            return;
        }
        MercurialTagAction prevTag = (MercurialTagAction)baseline;
        if (prevTag == null) {
            listener.getLogger().println("WARN: Revision data for previous build unavailable; unable to determine change log");
            this.createEmptyChangeLog(changelogFile, listener, "changelog");
            return;
        }
        EnvVars env = build.getEnvironment(listener);
        MercurialInstallation inst = MercurialSCM.findInstallation(this.getInstallation());
        StandardUsernameCredentials credentials = this.getCredentials(build.getParent(), env);
        try (HgExe hg = new HgExe(inst, credentials, launcher, node, listener, env);){
            ArgumentListBuilder logCommand = hg.seed(true).add(new String[]{"log", "--rev", prevTag.getId(), "--template", "exists\\n"});
            int exitCode = hg.launch(logCommand).pwd(repository).join();
            if (exitCode != 0) {
                listener.error("Previously built revision " + prevTag.getId() + " is not known in this clone; unable to determine change log");
                this.createEmptyChangeLog(changelogFile, listener, "changelog");
                return;
            }
            try (FileOutputStream os = new FileOutputStream(changelogFile);){
                os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes("UTF-8"));
                try {
                    os.write("<changesets>\n".getBytes("UTF-8"));
                    ArgumentListBuilder args = hg.seed(false);
                    args.add("log");
                    args.add(new String[]{"--template", "<changeset node='{node}' author='{author|xmlescape}' rev='{rev}' date='{date}'><msg>{desc|xmlescape}</msg><added>{file_adds|stringify|xmlescape}</added><deleted>{file_dels|stringify|xmlescape}</deleted><files>{files|stringify|xmlescape}</files><parents>{parents}</parents></changeset>\\n"});
                    if (this.revisionType == RevisionType.REVSET) {
                        args.add(new String[]{"--rev", "ancestors(" + revToBuild + ") and not ancestors(" + prevTag.getId() + ")"});
                    } else {
                        args.add(new String[]{"--rev", "ancestors('" + revToBuild.replace("'", "\\'") + "') and not ancestors(" + prevTag.getId() + ")"});
                    }
                    args.add(new String[]{"--encoding", "UTF-8"});
                    args.add(new String[]{"--encodingmode", "replace"});
                    ByteArrayOutputStream errorLog = new ByteArrayOutputStream();
                    int r = hg.launch(args).stdout((OutputStream)new ForkOutputStream((OutputStream)os, (OutputStream)errorLog)).pwd(repository).join();
                    if (r != 0) {
                        Util.copyStream((InputStream)new ByteArrayInputStream(errorLog.toByteArray()), (OutputStream)listener.getLogger());
                        throw new IOException("Failure detected while running hg log to determine change log");
                    }
                }
                finally {
                    os.write("</changesets>".getBytes("UTF-8"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Run<?, ?> build, Launcher launcher, FilePath repository, Node node, TaskListener listener, String toRevision, StandardUsernameCredentials credentials) throws IOException, InterruptedException {
        HgExe hg = new HgExe(MercurialSCM.findInstallation(this.getInstallation()), credentials, launcher, node, listener, build.getEnvironment(listener));
        EnvVars env = build.getEnvironment(listener);
        try {
            String branch;
            CachedRepo cachedSource;
            int updateExitCode;
            int pullExitCode;
            try {
                pullExitCode = this.pull(launcher, repository, listener, node, toRevision, credentials, env);
            }
            catch (IOException e) {
                if (this.causedByMissingHg(e)) {
                    listener.error("Failed to pull because hg could not be found; check that you've properly configured your Mercurial installation");
                } else {
                    e.printStackTrace(listener.error("Failed to pull"));
                }
                throw new AbortException("Failed to pull");
            }
            if (pullExitCode != 0) {
                listener.error("Failed to pull");
                throw new AbortException("Failed to pull");
            }
            try {
                updateExitCode = hg.run("update", "--clean", "--rev", toRevision).pwd(repository).join();
            }
            catch (IOException e) {
                listener.error("Failed to update");
                e.printStackTrace(listener.getLogger());
                throw new AbortException("Failed to update");
            }
            if (updateExitCode != 0) {
                listener.error("Failed to update");
                throw new AbortException("Failed to update");
            }
            if (build.getNumber() % 100 == 0 && (cachedSource = this.cachedSource(node, env, launcher, listener, true, credentials)) != null && !cachedSource.isUseSharing()) {
                hg.run("--config", "extensions.relink=", "relink", cachedSource.getRepoLocation()).pwd(repository).join();
            }
            if (this.clean && hg.cleanAll().pwd(repository).join() != 0) {
                listener.error("Failed to clean unversioned files");
                throw new AbortException("Failed to clean unversioned files");
            }
            String tip = hg.tip(repository, null);
            String rev = hg.tipNumber(repository, null);
            String string = branch = this.revisionType != RevisionType.BRANCH ? hg.branch(repository, null) : null;
            if (tip != null && rev != null) {
                build.addAction((Action)new MercurialTagAction(tip, rev, this.getSubdir(env), branch));
            }
        }
        finally {
            hg.close();
        }
    }

    private String getRevToBuild(Run<?, ?> build, FilePath workspace, EnvVars env) {
        String revToBuild = this.getRevision(env);
        if (build instanceof MatrixRun) {
            MatrixRun matrixRun = (MatrixRun)build;
            MercurialTagAction parentRevision = null;
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null && jenkins.getPlugin("multiple-scms") != null) {
                SCMRevisionState _parentRevisions;
                MultiSCMRevisionState parentRevisions = (MultiSCMRevisionState)matrixRun.getParentBuild().getAction(MultiSCMRevisionState.class);
                if (parentRevisions != null && (_parentRevisions = parentRevisions.get((SCM)this, workspace, (AbstractBuild)((MatrixRun)build))) instanceof MercurialTagAction) {
                    parentRevision = (MercurialTagAction)_parentRevisions;
                }
                if (parentRevisions == null) {
                    parentRevision = (MercurialTagAction)matrixRun.getParentBuild().getAction(MercurialTagAction.class);
                }
            } else {
                parentRevision = (MercurialTagAction)matrixRun.getParentBuild().getAction(MercurialTagAction.class);
            }
            if (parentRevision != null && parentRevision.getId() != null) {
                revToBuild = parentRevision.getId();
            }
        }
        return revToBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clone(Run<?, ?> build, Launcher launcher, FilePath repository, Node node, TaskListener listener, String toRevision, StandardUsernameCredentials credentials) throws InterruptedException, IOException {
        try {
            repository.deleteRecursive();
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clean the repository checkout"));
            throw new AbortException("Failed to clean the repository checkout");
        }
        EnvVars env = build.getEnvironment(listener);
        try (HgExe hg = new HgExe(MercurialSCM.findInstallation(this.getInstallation()), credentials, launcher, node, listener, env);){
            String branch;
            int cloneExitCode;
            ArgumentListBuilder args = hg.seed(true);
            CachedRepo cachedSource = this.cachedSource(node, env, launcher, listener, false, credentials);
            if (cachedSource != null) {
                if (cachedSource.isUseSharing()) {
                    args.add(new String[]{"--config", "extensions.share="});
                    args.add("share");
                    args.add("--noupdate");
                    args.add(cachedSource.getRepoLocation());
                    if (new VersionNumber(hg.version()).compareTo(new VersionNumber("3.3")) >= 0) {
                        args.add("-B");
                    }
                } else {
                    args.add("clone");
                    args.add("--noupdate");
                    args.add(cachedSource.getRepoLocation());
                }
            } else {
                args.add("clone");
                if (this.revisionType == RevisionType.BRANCH || this.revisionType == RevisionType.CHANGESET) {
                    args.add(new String[]{"--rev", toRevision});
                }
                args.add("--noupdate");
                args.add(this.getSource(env));
            }
            args.add(repository.getRemote());
            repository.mkdirs();
            try {
                cloneExitCode = hg.launch(args).join();
            }
            catch (IOException e) {
                if (this.causedByMissingHg(e)) {
                    listener.error("Failed to clone " + this.getSource(env) + " because hg could not be found; check that you've properly configured your Mercurial installation");
                } else {
                    e.printStackTrace(listener.error(Messages.MercurialSCM_failed_to_clone(this.getSource(env))));
                }
                throw new AbortException(Messages.MercurialSCM_failed_to_clone(this.getSource(env)));
            }
            if (cloneExitCode != 0) {
                listener.error(Messages.MercurialSCM_failed_to_clone(this.getSource(env)));
                throw new AbortException(Messages.MercurialSCM_failed_to_clone(this.getSource(env)));
            }
            if (cachedSource != null && !cachedSource.isUseSharing()) {
                FilePath hgrc = repository.child(".hg/hgrc");
                if (hgrc.exists()) {
                    String hgrcText = hgrc.readToString();
                    if (!hgrcText.contains(cachedSource.getRepoLocation())) {
                        listener.error(".hg/hgrc did not contain " + cachedSource.getRepoLocation() + " as expected:\n" + hgrcText);
                        throw new AbortException(".hg/hgrc did not contain " + cachedSource.getRepoLocation() + " as expected:\n" + hgrcText);
                    }
                    hgrc.write(hgrcText.replace(cachedSource.getRepoLocation(), this.getSource(env)), null);
                }
                hg.run("--config", "extensions.relink=", "relink", cachedSource.getRepoLocation()).pwd(repository).join();
            }
            ArgumentListBuilder upArgs = hg.seed(true);
            upArgs.add("update");
            upArgs.add(new String[]{"--rev", toRevision});
            if (hg.launch(upArgs).pwd(repository).join() != 0) {
                throw new AbortException("Failed to update " + this.getSource(env) + " to rev " + toRevision);
            }
            String tip = hg.tip(repository, null);
            String rev = hg.tipNumber(repository, null);
            String string = branch = this.revisionType != RevisionType.BRANCH ? hg.branch(repository, null) : null;
            if (tip != null && rev != null) {
                build.addAction((Action)new MercurialTagAction(tip, rev, this.getSubdir(env), branch));
            }
        }
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        this.buildEnvironment((Run<?, ?>)build, env);
    }

    public void buildEnvironment(Run<?, ?> build, Map<String, String> env) {
        this.buildEnvVarsFromActionable((Actionable)build, env);
    }

    void buildEnvVarsFromActionable(Actionable build, Map<String, String> env) {
        MercurialTagAction a = this.findTag(build, new EnvVars(env));
        if (a != null) {
            env.put(ENV_MERCURIAL_REVISION, a.id);
            env.put(ENV_MERCURIAL_REVISION_SHORT, a.getShortId());
            env.put(ENV_MERCURIAL_REVISION_NUMBER, a.rev);
            if (this.revisionType != RevisionType.BRANCH) {
                env.put(ENV_MERCURIAL_REVISION_BRANCH, a.getBranch());
            }
            env.put(ENV_MERCURIAL_REPOSITORY_URL, this.getSource());
        }
    }

    private MercurialTagAction findTag(Actionable build, EnvVars env) {
        for (Action action : build.getActions()) {
            if (!(action instanceof MercurialTagAction)) continue;
            MercurialTagAction tag = (MercurialTagAction)action;
            String ourSubDir = this.getSubdir(env);
            String tagSubDir = tag.getSubdir();
            if ((ourSubDir != null || tagSubDir != null) && (ourSubDir == null || !ourSubDir.equals(tagSubDir))) continue;
            return tag;
        }
        return null;
    }

    public ChangeLogParser createChangeLogParser() {
        return new MercurialChangeLogParser(this._modules);
    }

    public FilePath getModuleRoot(FilePath workspace, AbstractBuild build) {
        if (build != null) {
            try {
                EnvVars env = build.getEnvironment((TaskListener)new LogTaskListener(LOGGER, Level.INFO));
                return this.workspace2Repo(workspace, env);
            }
            catch (IOException ex) {
                Logger.getLogger(MercurialSCM.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MercurialSCM.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        EnvVars env = new EnvVars();
        return this.workspace2Repo(workspace, env);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getModules() {
        return this.modules;
    }

    @DataBoundSetter
    public final void setModules(String modules) {
        this.modules = Util.fixNull((String)modules);
        this.parseModules();
    }

    private boolean causedByMissingHg(IOException e) {
        String message = e.getMessage();
        return message != null && message.startsWith("Cannot run program") && message.endsWith("No such file or directory");
    }

    @CheckForNull
    private CachedRepo cachedSource(Node node, EnvVars env, Launcher launcher, TaskListener listener, boolean useTimeout, StandardUsernameCredentials credentials) throws InterruptedException {
        MercurialInstallation inst = MercurialSCM.findInstallation(this.installation);
        if (inst == null || !inst.isUseCaches()) {
            return null;
        }
        try {
            FilePath cache = Cache.fromURL(this.getSource(env), credentials, inst.getMasterCacheRoot()).repositoryCache(inst, node, launcher, listener, useTimeout);
            if (cache != null) {
                return new CachedRepo(cache.getRemote(), inst.isUseSharing());
            }
            listener.error("Failed to use repository cache for " + this.getSource(env));
            return null;
        }
        catch (InterruptedException x) {
            throw x;
        }
        catch (Exception x) {
            x.printStackTrace(listener.error("Failed to use repository cache for " + this.getSource(env)));
            return null;
        }
    }

    @CheckForNull
    private static Node workspaceToNode(FilePath workspace) {
        Jenkins j = Jenkins.getInstance();
        if (j != null && workspace.isRemote()) {
            for (Computer c : j.getComputers()) {
                Node n;
                if (c.getChannel() != workspace.getChannel() || (n = c.getNode()) == null) continue;
                return n;
            }
        }
        return j;
    }

    private static List<? extends StandardUsernameCredentials> availableCredentials(Job<?, ?> owner, String source) {
        return CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, owner, null, (List)URIRequirementBuilder.fromUri((String)source).build());
    }

    @Extension
    public static final class DescriptorImpl
    extends SCMDescriptor<MercurialSCM> {
        private String hgExe;

        public DescriptorImpl() {
            super(HgBrowser.class);
            this.load();
        }

        public String getDisplayName() {
            return "Mercurial";
        }

        public String getHgExe() {
            if (this.hgExe == null) {
                return "hg";
            }
            return this.hgExe;
        }

        public boolean isApplicable(Job project) {
            return true;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (SCM)super.newInstance(req, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.hgExe = req.getParameter("mercurial.hgExe");
            this.save();
            return true;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Job<?, ?> owner, @QueryParameter String source) {
            if (!this.hasAccessToCredentialsMetadata(owner)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().withEmptySelection().withAll((Iterable)MercurialSCM.availableCredentials(owner, new EnvVars().expand(source)));
        }

        private boolean hasAccessToCredentialsMetadata(Job<?, ?> owner) {
            if (owner == null) {
                return Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER);
            }
            return owner.hasPermission(Item.EXTENDED_READ);
        }
    }

    private static class CachedRepo {
        private final String repoLocation;
        private final boolean useSharing;

        private CachedRepo(String repoLocation, boolean useSharing) {
            this.repoLocation = repoLocation;
            this.useSharing = useSharing;
        }

        public String getRepoLocation() {
            return this.repoLocation;
        }

        public boolean isUseSharing() {
            return this.useSharing;
        }
    }

    public static enum RevisionType {
        BRANCH{

            @Override
            public String getDisplayName() {
                return "Branch";
            }
        }
        ,
        TAG{

            @Override
            public String getDisplayName() {
                return "Tag";
            }
        }
        ,
        CHANGESET{

            @Override
            public String getDisplayName() {
                return "Changeset";
            }
        }
        ,
        REVSET{

            @Override
            public String getDisplayName() {
                return "Revset";
            }
        };


        public abstract String getDisplayName();
    }
}

